//全局的JSID到JavaID的映射
var jsIdToJavaMap={};
//全局的JavaID到JSID的映射
var javaIdToJSMap={};

//js回调
function sdk_java_callback(obj){
    //互换数据
    let jsID= obj['id'];
    obj['id']=jsIdToJavaMap[jsID];
    var jsonStr = JSON.stringify(obj );
    jsonStr = jsonStr.replace(/undefined,0/g,"0");
    window.myTosat.sdkJavaCallback(jsonStr);
}

function sdk_java_log(obj){
    var jsonStr = JSON.stringify(obj );
    window.myTosat.sdkJavaLog(jsonStr);
}

function sdk_java_notification(obj){
    var jsonStr = JSON.stringify(obj );
    window.myTosat.sdkJavaNotification(jsonStr);
}

function sdk_java_sign_callback(){
     var abc = window.myTosat.sdkJavaSignCallback();
     var promise = new Promise(function (resolve, reject) {
         window.signAutoResolve = resolve;
         window.signAutoReject = reject;
     });
     console.log("调用了安卓的签名",abc);
     return promise;
}

function setDeviceSignatrue(){
    let keyName = 'device_id_internal';
    let oldValue = localStorage.getItem(keyName);
    if(oldValue =='' || oldValue ===undefined || 'NULL' ==oldValue){
        oldValue = generateDeviceIdInternal();
        localStorage.setItem(keyName,oldValue);
    }
}

/**
 * 构建Rquest对象
 * @param {*} jid  Java对象ID
 * @param {*} api  请求的API名称
 * @returns 
 */
function createRequestItem(javaId,api){
    let jsID = javaIdToJSMap[javaId];
    if(jsID =='' || jsID ===undefined || 'NULL' ==jsID || null==jsID){
        let itemId = NSDK.createRequestItem(api);
        jsID = itemId['id'];
    }
    let requestItem = NSDK.getRequestItemsById(jsID);
    if(null != requestItem){
        jsIdToJavaMap[jsID] = javaId;
        javaIdToJSMap[javaId] = jsID;
    }
    return requestItem;
}

/**
 * 通用请求
 * @param jid Java对象中的ID
 * @param api api
 * @param params 参数
 * @param rangeField 区间字段
 * @param begin  区间字段开始索引
 * @param end    区间字段结束索引
 * @param sortField 排序字段
 * @param sortType  排序类型
 */
function requestForGRequestCommon(jid,api,params,rangeField,begin,end,sortField,sortType){
     let requestItem = createRequestItem(jid,'GRequestCommon');
     if(api !==null){
        requestItem.setAPI(api);
     }
     if(params !==null){
        Object.keys(params).forEach(function(key){
            requestItem.setParam(key,params[key]);
        });
     }
     if(rangeField !== null && begin !==null && end !==null){
        requestItem.setRange(rangeField,begin,end);
     }
     if(sortField !==null && sortType!==null){
        requestItem.setSortField(sortField,sortType);
     }
     requestItem.request();
}

/**
 * 请求键盘精灵
 * @param {*} jid   Java对象ID 
 * @param {*} api   键盘精灵的API
 * @param {*} category 栏目
 * @param {*} market   分类
 * @param {*} fields   返回的字段
 * @param {*} pageNo   页号
 * @param {*} pageSize 每页大小
 */
function requestForGKeyWizard(jid,keyword,api,category,market,fields,pageNo,pageSize){
    let requestItem= createRequestItem(jid,'GKeyWizard');
    if(api !==null){
        requestItem.setAPI(api);
    }
    requestItem.setCategory(category);
    requestItem.setMarket(market);
    requestItem.setFields(fields);
    requestItem.setPageNo(pageNo);
    requestItem.setPageSize(pageSize);
    requestItem.match(keyword);
}

/**
 * 集合竞价请求
 * @param {*} jid       java对象ID
 * @param {*} code      java代码
 * @param {*} subscribe 订阅
 * @param {*} fields    字段
 * @param {*} fields    频率
 */
function requestForGCallAution(jid,code,fields,subscribe,frequency){
    let requestItem= createRequestItem(jid,'GCallAution');
    requestItem.setCode(code);
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.setFrequency(frequency);
    requestItem.setFields(fields);
    requestItem.request();
}

/**
 * 复权因子
 * @param {*} jid 
 * @param {*} code 
 * @param {*} fields 
 * @param {*} subscribe 
 */
function requestGAdjustedInfo(jid,code,fields,subscribe){
    let requestItem= createRequestItem(jid,'GAdjustedInfo');
    requestItem.setCode(code);
    if(fields !== null){
        requestItem.setFields(fields);
    }
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.request();
}

/**
 * 盘后走势分析
 * @param {*} jid 
 * @param {*} code 
 * @param {*} fields 
 * @param {*} subscribe 
 */
function requestGAfterHoursTrend(jid,code,fields,subscribe){
    let requestItem= createRequestItem(jid,'GAfterHoursTrend');
    requestItem.setCode(code);
    requestItem.setFields(fields);
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.request();
}

/**
 * K线请求
 * @param {*} jid         java对象ID
 * @param {*} code        请求代码
 * @param {*} fields      返回字段
 * @param {*} period      周期
 * @param {*} cqmode      复权模式
 * @param {*} beginDate   开始时间
 * @param {*} endDate     结束时间
 * @param {*} begin       开始索引
 * @param {*} count       个数 
 * @param {*} params      其他参数
 * @param {*} subscribe   是否订阅
 */
function requestForGKline(jid,code,fields,period,cqmode,beginDate,endDate,begin,count,params,subscribe){
    let requestItem= createRequestItem(jid,'GKLine');
    requestItem.setCode(code);
    if(fields !== null){
        requestItem.setFields(fields);
    }
    if(period !== null){
        requestItem.setPeriod(period);
    }
    if(cqmode !== null){
        requestItem.setCqMode(cqmode);
    }
    if(beginDate !== null && endDate !==null){
        requestItem.setDateRange(beginDate,endDate);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    if(params !==null){
        Object.keys(params).forEach(function(key){
            requestItem.setParam(key,params[key]);
        });
    }
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.request();
}

/**
 * 销毁请求
 * @param {*} jid JavaID对象
 */
function destroyRequestItemById(jid){
    let jsID = javaIdToJSMap[jid];
    NSDK.destroyRequestItemById(jsID);
    delete javaIdToJSMap[jid];
    delete jsIdToJavaMap[jsID];
}

/**
 * 清除所有请求
 */
function clearAllRequestItems(){
    jsIdToJavaMap ={};
    javaIdToJSMap ={};
    NSDK.clearAllRequestItems();
}


/**
 * 清除所有请求
 */
function clearRequestItemParams(jid){
    let jsId = javaIdToJSMap[jid];
    let requestItem = NSDK.getRequestItemsById(jsID);
    if(requestItem !==null){
        requestItem.clearParams();
    }
}

/**
 * 逐笔委托请求
 * @param {*} jid        java对象ID
 * @param {*} code       请求的代码
 * @param {*} fields     请求的字段
 * @param {*} subscribe  是否订阅
 * @param {*} begin      开始索引
 * @param {*} count      个数 
 */
function requestForGOrder(jid,code,fields,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GOrder');
    requestItem.setCode(code);
    requestItem.setFields(fields);
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 
 * @param {*} jid        Java对象ID
 * @param {*} code       请求代码
 * @param {*} fields     请求字段
 * @param {*} subscribe  是否订阅
 * @param {*} begin      开始索引
 * @param {*} count      个数
 */
function requestForGCancelOrder(jid,code,fields,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GCancelOrder');
    requestItem.setCode(code);
    requestItem.setFields(fields);
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 资金流向请求
 * @param {*} jid   Java对象 
 * @param {*} code  请求代码
 */
function requestForGMoneyFlow(jid,code){
    let requestItem= createRequestItem(jid,'GMoneyFlow');
    requestItem.setCode(code);
    requestItem.request();
}

/**
 * 历史分时请求
 * @param {*} jid     java对象ID
 * @param {*} code    请求code
 * @param {*} date    日期
 * @param {*} fields  请求字段
 */
function requestForGHisTrend(jid,code,date,fields){
    let requestItem= createRequestItem(jid,'GHisTrend');
    requestItem.setCode(code);
    requestItem.setDate(date);
    requestItem.setFields(fields);
    requestItem.request();
}

/**
 * 指数ID请求
 * @param {*} jid  java对象ID
 * @param {*} code 请求代码
 */
function requestForGIndexToSector(jid,code){
    let requestItem= createRequestItem(jid,'GIndexToSector');
    requestItem.setCode(code);
    requestItem.request();
}

/**
 * 分价统计请求
 * @param {*} jid        java对象ID
 * @param {*} code       请求代码
 * @param {*} fields     请求字段
 * @param {*} subscribe  是否订阅
 * @param {*} begin      开始索引
 * @param {*} count      数量 
 */
function requestForGPriceDistribution(jid,code,fields,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GPriceDistribution');
    requestItem.setCode(code);
    requestItem.setFields(fields);
    if(subscribe !==null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 行情订阅数据请求
 * @param {*} jid     Java对象ID
 * @param {*} codes   代码列表
 * @param {*} fields  字段列表
 */
function requestForGQuoteSubscribe(jid,codes,fields){
    let requestItem= createRequestItem(jid,'GQuoteSubscribe');
    requestItem.setCodes(codes);
    requestItem.setFields(fields);
    requestItem.request();
}

/**
 * 行情静态指标请求
 * @param {*} jid     Java对象ID
 * @param {*} codes   代码列表
 * @param {*} fields  字段列表
 */
function requestForGQuoteStatic(jid,codes,fields){
    let requestItem= createRequestItem(jid,'GQuoteStatic');
    requestItem.setCodes(codes);
    requestItem.setFields(fields);
    requestItem.request();
}

/**
 * 定制行情请求
 * @param {*} jid  Java对象ID
 * @param {*} api  API名称
 * @param {*} params 参数
 */
function requestForGRequestCustomQuote(jid,api,params){
    let requestItem= createRequestItem(jid,'GRequestCustomQuote');
    if(api !==null){
        requestItem.setAPI(api);
    }
    if(params !==null){
        Object.keys(params).forEach(function(key){
            requestItem.setParam(key,params[key]);
        });
     }
    requestItem.request();
}

/**
 * 时间序列数据
 * @param {*} jid  Java对象ID
 * @param {*} api  API名称
 * @param {*} params 参数
 */
function requestForGSeQuence(jid,api,params){
    let requestItem= createRequestItem(jid,'GSeQuence');
    if(api !==null){
        requestItem.setAPI(api);
    }
    if(params !==null){
        Object.keys(params).forEach(function(key){
            requestItem.setParam(key,params[key]);
        });
    }
    requestItem.request();
}

/**
 * 板块成分
 * @param {*} jid       Java对象ID
 * @param {*} sectorid  板块ID
 * @param {*} begin     开始索引
 * @param {*} count     个数
 */
function requestForGSectorConstituents(jid,sectorid,begin,count){
    let requestItem= createRequestItem(jid,'GSectorConstituents');
    requestItem.setSectorId(sectorid);
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 板块排序请求
 * @param {*} jid 
 * @param {*} codes
 * @param {*} fields
 * @param {*} sectorId
 * @param {*} sortField 
 * @param {*} sortType 
 * @param {*} subscribe 
 * @param {*} begin 
 * @param {*} count 
 */
function requestForGSort(jid,codes,fields,sectorId,sortField,sortType,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GSort');
    if(codes !==null){
        requestItem.setCodes(codes);
    }
    if(fields != null){
        requestItem.setFields(fields);
    }
    if(sectorId !== null){
        requestItem.setSectorId(sectorId);
    }
    if(sortField !== null && sortType !==null){
        requestItem.setSortField(sortField,sortType);
    }
    if(subscribe !== null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 逐笔成交请求
 * @param {*} jid 
 * @param {*} code 
 * @param {*} fields 
 * @param {*} subscribe 
 * @param {*} begin 
 * @param {*} count 
 */
function requestForGStep(jid,code,fields,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GStep');
    requestItem.setCode(code);
    if(fields !== null){
        requestItem.setFields(fields);
    }
    if(subscribe !== null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 分笔成交请求对象
 * @param {*} jid 
 * @param {*} code 
 * @param {*} fields 
 * @param {*} subscribe 
 * @param {*} begin 
 * @param {*} count 
 */
function requestForGTick(jid,code,fields,subscribe,begin,count){
    let requestItem= createRequestItem(jid,'GTick');
    requestItem.setCode(code);
    if(fields !== null){
        requestItem.setFields(fields);
    }
    if(subscribe !== null){
        requestItem.setSubscribe(subscribe);
    }
    if(begin !==null && count !==null){
        requestItem.setLimit(begin,count);
    }
    requestItem.request();
}

/**
 * 买卖队列
 * @param {*} jid 
 * @param {*} code 
 * @param {*} type 
 */
function requestForGTradeQueue(jid,code,type){
    let requestItem= createRequestItem(jid,'GTradeQueue');
    requestItem.setCode(code);
    requestItem.setType(type);
    requestItem.request();
}

/**
 *  获取分时数据（含多日）
 * @param {*} jid 
 * @param {*} code 
 * @param {*} days 
 * @param {*} fields 
 * @param {*} subscribe 
 */
function requestForGTrend(jid,code,days,fields,subscribe){
    let requestItem= createRequestItem(jid,'GTrend');
    requestItem.setCode(code);
    if(days !==null){
        requestItem.setDays(days);
    }
    if(fields !== null){
        requestItem.setFields(fields);
    }
    if(subscribe !== null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.request();
}

/**
 * 指数涨跌家数统计请求
 * @param {*} jid 
 * @param {*} code 
 */
function requestForGUpDownDistribution(jid,code){
    let requestItem= createRequestItem(jid,'GUpDownDistribution');
    requestItem.setCode(code);
    requestItem.request();
}

/**
 * 成交量分布请求
 * @param {*} jid 
 * @param {*} code 
 * @param {*} subscribe 
 */
function requestForGVolumeDistribution(jid,code,subscribe){
    let requestItem= createRequestItem(jid,'GVolumeDistribution');
    requestItem.setCode(code);
    if(subscribe !== null){
        requestItem.setSubscribe(subscribe);
    }
    requestItem.request();
}

/**
 * 个股信息
 * @param {*} jid 
 * @param {*} codes 
 * @param {*} fields 
 */
function requestForNStockInfo(jid,codes,fields){
    let requestItem= createRequestItem(jid,'NStockInfo');
    requestItem.setCodes(codes);
    if(fields !== null){
        requestItem.setFields(fields);
    }
    requestItem.request();
}

//js调用java
function showToast(){
    window.myTosat.showMessage();
}

function javaGetFormulaData(cqResult,formulaName,params){
    return GEngineApply.sharedInstance().getFormulaData(cqResult,formulaName,params);
}

NSDK_HOOK.start()

