let _rt = loadRuntime();

// module InterfaceInteraction
let _checkColor = function (color) {
    let isColor = true;

    if (typeof color === "string" && color.length === 6) {
        color = color.toUpperCase();

        for (let index = 0; index < 6; index++) {
            let charCode = color.charCodeAt(index);

            if (charCode < 48 || (charCode > 57 && charCode < 65) || charCode > 70) {
                isColor = false;
                break;
            }
        }
    } else {
        isColor = false;
    }

    return isColor;
};

let _getCallBackObj = function (res) {
    let callBackObj = {};

    if (typeof res.success === "function") {
        callBackObj.success = res.success;
    }
    if (typeof res.fail === "function") {
        callBackObj.fail = res.fail;
    }
    if (typeof res.complete === "function") {
        callBackObj.complete = res.complete;
    }

    return callBackObj;
};

_rt.showToast = function (res) {
    if (!res) {
        res = {};
    }

    let callBackObj = _getCallBackObj(res);
    _rt.callCustomCommand(callBackObj, "rt-show-toast", JSON.stringify({
        title: res.title || "",
        icon: res.icon || "success",
        image: res.image || null,
        duration: res.duration || 1500,
        mask: !!res.mask
    }));
};

_rt.hideToast = function (res) {
    if (!res) {
        res = {};
    }

    let callBackObj = _getCallBackObj(res);
    _rt.callCustomCommand(callBackObj, "rt-hide-toast");
};

_rt.showModal = function (res) {
    if (!res) {
        res = {};
    }

    if (!_checkColor(res.cancelColor)) {
        res.cancelColor = "000000";
    }
    if (!_checkColor(res.confirmColor)) {
        res.confirmColor = "576B95";
    }

    let callBackObj = _getCallBackObj(res);
    _rt.callCustomCommand(callBackObj, "rt-show-modal", JSON.stringify({
        title: res.title || "",
        content: res.content || "",
        showCancel: !!res.showCancel,
        cancelText: res.cancelText || "取消",
        cancelColor: res.cancelColor,
        confirmText: res.confirmText || "确定",
        confirmColor: res.confirmColor
    }));
},

    _rt.showActionSheet = function (res) {
        if (!res) {
            res = {};
        }

        if (!_checkColor(res.itemColor)) {
            res.itemColor = "000000";
        }

        let callBackObj = _getCallBackObj(res);
        _rt.callCustomCommand(callBackObj, "rt-show-action-sheet", JSON.stringify({
            itemList: res.itemList || [],
            itemColor: res.itemColor
        }));
    },

    _rt.showLoading = function (res) {
        if (!res) {
            res = {};
        }

        let data = {};
        if (typeof res.success === "function") {
            data.success = res.success;
        }
        if (typeof res.fail === "function") {
            data.fail = res.fail;
        }
        if (typeof res.complete === "function") {
            data.complete = res.complete;
        }

        _rt.callCustomCommand(data, "rt-show-loading", JSON.stringify({
            title: res.title || "",
            mask: !!res.mask
        }));
    },

    _rt.hideLoading = function (res) {
        if (!res) {
            res = {};
        }

        let data = {};
        if (typeof res.success === "function") {
            data.success = res.success;
        }
        if (typeof res.fail === "function") {
            data.fail = res.fail;
        }
        if (typeof res.complete === "function") {
            data.complete = res.complete;
        }

        _rt.callCustomCommand(data, "rt-hide-loading");
    }

if (!_rt.getUserInfo) {
    let _callback = function (cb, failArgs, successArgs, compArgs) {
        if (cb === undefined) {
            return;
        }
        if (failArgs !== undefined) {
            if (typeof cb.fail === "function") {
                cb.fail.apply(cb, failArgs);
            }
        } else {
            if (typeof cb.success == "function") {
                cb.success.apply(cb, successArgs);
            }
        }
        if (typeof cb.complete === "function") {
            cb.complete.apply(cb, compArgs);
        }
    };
    _rt.getUserInfo = function (cb) {
        _rt.authorize({
            scope: "scope.userInfo",
            success() {
                console.log("authorize user info success");
                let onGetUserInfoCb = function (res) {
                    try {
                        let obj = JSON.parse(res);
                        _callback(cb, undefined, [obj]);
                    } catch (e) {
                        let errorMsg = "user info parse error";
                        _callback(cb, [errorMsg]);
                    }
                };
                _rt.callCustomCommand({
                    success: onGetUserInfoCb,
                    fail: cb.fail,
                    complete: cb.complete
                }, "getUserInfo");
            },
            fail() {
                let errorMsg = "without user info permission";
                _callback(cb, [errorMsg]);
            }
        });
    };
}

if (!_rt.saveImageToPhotosAlbum) {
    _rt.saveImageToPhotosAlbum = function (object) {
        let filePath = "";
        if (typeof object === "object") {
            if (typeof object.filePath === "string") {
                filePath = object.filePath;
            }
        } else {
            object = {};
        }
        _rt.callCustomCommand({
            success: object.success,
            fail: object.fail,
            complete: object.complete
        }, "rt-media-image-save-image-to-photos-album", filePath);
    };
}

if (!_rt.previewImage) {
    _rt.previewImage = function (object) {
        let current = "";
        let urls = [];
        if (typeof object === "object") {
            if (typeof object.current === "string") {
                current = object.current;
            }
            let array = object.urls;
            if (Array.isArray(array)) {
                let length = array.length;
                for (let index = 0; index < length; ++index) {
                    if (typeof array[index] === "string") {
                        urls.push(array[index]);
                    }
                }
            }
        } else {
            object = {};
        }
        _rt.callCustomCommand({
            success: object.success,
            fail: object.fail,
            complete: object.complete
        }, "rt-media-image-preview-image", current, urls);
    };
}

if (!_rt.chooseImage) {
    _rt.chooseImage = function (object) {
        let count = 9;
        let sizeType = ['original', 'compressed'];
        let sourceType = ['album', 'camera'];
        if (typeof object === "object") {
            if (typeof object.count === "number") {
                count = object.count;
            }
            if (Array.isArray(object.sizeType)) {
                let array = object.sizeType;
                let length = array.length;
                let original = false;
                let compressed = false;
                for (let index = 0; index < length; ++index) {
                    if (array[index] === "original") {
                        original = true;
                    } else if (array[index] === "compressed") {
                        original = true;
                    }
                }
                if (original) {
                    if (!compressed) {
                        sizeType = ["original"];
                    }
                } else if (compressed) {
                    sizeType = ["compressed"];
                }
            }
            if (Array.isArray(object.sourceType)) {
                let array = object.sourceType;
                let length = array.length;
                let album = false;
                let camera = false;
                for (let index = 0; index < length; ++index) {
                    if (array[index] === "album") {
                        album = true;
                    } else if (array[index] === "camera") {
                        camera = true;
                    }
                }
                if (album) {
                    if (!camera) {
                        sourceType = ["album"];
                    }
                } else if (camera) {
                    sourceType = ["camera"];
                }
            }
        } else {
            object = {};
        }
        _rt.callCustomCommand({
            success: function (choices) {
                let tempFilePaths = [];
                let tempFiles = [];
                let length = choices.length;
                for (let index = 0; index < length; index += 2) {
                    tempFilePaths[index / 2] = choices[index];
                    tempFiles[index / 2] = {
                        path: choices[index],
                        size: parseInt(choices[index + 1])
                    };
                }
                if (typeof object.success == "function") {
                    object.success({
                        tempFilePaths: tempFilePaths.slice(),
                        tempFiles: tempFiles.slice()
                    });
                }
                if (typeof object.complete == "function") {
                    object.complete({
                        tempFilePaths: tempFilePaths,
                        tempFiles: tempFiles
                    });
                }
            },
            fail: function (res) {
                if (typeof object.fail == "function") {
                    object.fail(res);
                }
                if (typeof object.complete == "function") {
                    object.complete(res);
                }
            },
        }, "rt-media-image-choose-image", count, sizeType, sourceType);
    };
}

if (!_rt.openSetting) {
    _rt.openSetting = function (object) {
        if (typeof object !== "object") {
            object = {};
        }
        _rt.callCustomCommand({
            success: function (res) {
                if (typeof object.success == "function") {
                    object.success(JSON.parse(res));
                }
                if (typeof object.complete == "function") {
                    object.complete(JSON.parse(res));
                }
            },
            fail: function (res) {
                if (typeof object.fail == "function") {
                    object.fail(res);
                }
                if (typeof object.complete == "function") {
                    object.complete(res);
                }
            },
        }, "rt-open-setting");
    };
}

if (!_rt.getSetting) {
    _rt.getSetting = function (object) {
        if (typeof object !== "object") {
            object = {};
        }
        _rt.callCustomCommand({
            success: function (res) {
                if (typeof object.success == "function") {
                    object.success(JSON.parse(res));
                }
                if (typeof object.complete == "function") {
                    object.complete(JSON.parse(res));
                }
            },
            fail: function (res) {
                if (typeof object.fail == "function") {
                    object.fail(res);
                }
                if (typeof object.complete == "function") {
                    object.complete(res);
                }
            },
        }, "rt-get-setting");
    };
}

//let _menuButtonBoundingClientRect = {
//    left: 0,
//    right: 0,
//    top: 0,
//    bottom: 0,
//    width: 0,
//    height: 0
//};
//let _listeningMenuBoundingClientRect = function (first) {
//    _rt.callCustomCommand({
//        success: function (res) {
//            // res[0] x, res[1] y, res[2] width, res[3] height
//            _menuButtonBoundingClientRect.left = res[0];
//            _menuButtonBoundingClientRect.top = res[1];
//            _menuButtonBoundingClientRect.right = res[0] + res[2];
//            _menuButtonBoundingClientRect.bottom = res[1] + res[3];
//            _menuButtonBoundingClientRect.width = res[2];
//            _menuButtonBoundingClientRect.height = res[3];
//            _listeningMenuBoundingClientRect(false);
//        },
//        fail: function () {
//            setTimeout(function () {
//                _listeningMenuBoundingClientRect(first);
//            }, 200);
//        },
//    }, "rt-get-menu-bounding-client-rect", first);
//};
//_listeningMenuBoundingClientRect(true);
//_rt.getMenuButtonBoundingClientRect = function () {
//    return Object.assign({}, _menuButtonBoundingClientRect);
//};

//
// 小游戏和App交互
//
var _stateHandlerMap = {};
var _debug = true;
let _kTag = "mgrtsdk.js";
let _kVersion = "0.0.0.0";

const kCmdTypeGame = "game";
const kCmdTypePlayer = "player";

// sdk接口
let kApp2MgStateNotifyNetStatus = "a2ms-notify-net-status";
let kMg2AppStateGetNetStatus = "m2as-get-net-status";
let kMg2AppStateGetGameViewInfo = "m2as-get-game-view-info";
let kMg2AppStateVibrate = "m2as-vibrate";
let kMg2AppStateGetSDKInfo = "m2as-get-sdk-info";
let kMg2AppStateGetMGPVersion = "m2as-get-mgp-version";
let kMg2AppStateSetDebug = "m2as-set-debug";

// 业务
let kApp2MgStateUpdateCode = "a2ms-update-code";
let kApp2MgStateStateChange = "a2ms-state-change";
let kMg2AppStateExpireCode = "m2as-expire-code";
let kMg2AppStateLogin = "m2as-login";

if (!_rt.getMGPVersion) {
    _rt.getMGPVersion = function (callback) {
        _rt.mgSdkLog("info", "enter ====> expireCode");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetMGPVersion, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== expireCode");
    };
}

if (!_rt.mgSdkLog) {
    _rt.mgSdkLog = function (level, msg) {
        if (_debug) {
            if (level === "error") {
                console.error(_kTag + " " + msg);
            } else if (level === "warn") {
                console.warn(_kTag + " " + msg);
            } else {
                console.log(_kTag + " " + msg);
            }
        }
    };
}

if (!_rt.setDebug) {
    _rt.setDebug = function (debug) {
        _rt.mgSdkLog("info", "enter ====> setDebug");

        if (typeof debug === "boolean") {
            _debug = debug;
        }

        _rt.mgSdkLog("info", "leave <==== setDebug");
    };
}

// let callback = {
//     success: function(dataJson) {
//         console.log("resp result dataJson=" + dataJson);
//     },
//     fail: function(errMsg) {
//         console.log("errMsg=" + errMsg);
//     }
//     complete: function(res) {
//         console.log("res=" + res);
//     }
// };
// 1.小游戏==调用==>APP（公共接口）
if (!_rt.expireCode) {
    _rt.expireCode = function (callback) {
        _rt.mgSdkLog("info", "enter ====> expireCode");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateExpireCode, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== expireCode");
    };
}

if (!_rt.login) {
    _rt.login = function (callback) {
        _rt.mgSdkLog("info", "enter ====> login");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateLogin, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== login");
    };
}

if (!_rt.getNetStatus) {
    _rt.getNetStatus = function (callback) {
        _rt.mgSdkLog("info", "enter ====> getNetStatus");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetNetStatus, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== getNetStatus");
    };
}

if (!_rt.getGameViewInfo) {
    _rt.getGameViewInfo = function (callback) {
        _rt.mgSdkLog("info", "enter ====> getGameViewInfo");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetGameViewInfo, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== getGameViewInfo");
    };
}

if (!_rt.vibrate) {
    _rt.vibrate = function (milliseconds, callback) {
        _rt.mgSdkLog("info", "enter ====> vibrate");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateVibrate, JSON.stringify({ "milliseconds": milliseconds }), callback);

        _rt.mgSdkLog("info", "leave <==== vibrate");
    };
}

if (!_rt.getSDKInfo) {
    _rt.getSDKInfo = function (callback) {
        _rt.mgSdkLog("info", "enter ====> getSDKInfo");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetSDKInfo, "{}", callback);

        _rt.mgSdkLog("info", "leave <==== getSDKInfo");
    };
}

// let callback = {
//     success: function(dataJson) {
//         console.log("resp result dataJson=" + dataJson);
//     },
//     fail: function(errMsg) {
//         console.log("errMsg=" + errMsg);
//     }
// };

// state: "state-mg-xx-yy-zz"
if (!_rt.notifyStateChange) {
    _rt.notifyStateChange = function (type, param, state, dataJson, callback) {
        _rt.mgSdkLog("info", "enter ====> notifyStateChange");

        if (typeof state === "string" && typeof dataJson === "string") {
            _rt.callCustomCommand({
                success: function (res) {
                    if (callback != null && typeof callback.success == "function") {
                        callback.success(res);
                    }
                },
                fail: function (res) {
                    if (callback != null && typeof callback.fail == "function") {
                        callback.fail(res);
                    }
                },
                complete: function (res) {
                    if (callback != null && typeof callback.complete == "function") {
                        callback.complete(res);
                    }
                }
            }, type, param, state, dataJson);
        } else {
            _rt.mgSdkLog("error", "notifyStateChange state=" + state);
            _rt.mgSdkLog("error", "notifyStateChange dataJson=" + dataJson);
            let errMsg = "notifyStateChange state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog("error", errMsg);
        }

        _rt.mgSdkLog("info", "leave <==== notifyStateChange");
    };
}

if (!_rt.notifyGameStateChange) {
    _rt.notifyGameStateChange = function (state, dataJson, callback) {
        _rt.mgSdkLog("info", "enter ====> notifyGameStateChange");

        if (typeof state === "string" && typeof dataJson === "string") {
            _rt.notifyStateChange(kCmdTypeGame, "", state, dataJson, callback)
        } else {
            _rt.mgSdkLog("error", "notifyGameStateChange state=" + state);
            _rt.mgSdkLog("error", "notifyGameStateChange dataJson=" + dataJson);
            let errMsg = "notifyGameStateChange state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog("error", errMsg);
        }

        _rt.mgSdkLog("info", "leave <==== notifyGameStateChange");
    };
}

if (!_rt.notifyPlayerStateChange) {
    _rt.notifyPlayerStateChange = function (userId, state, dataJson, callback) {
        _rt.mgSdkLog("info", "enter ====> notifyPlayerStateChange");

        if (typeof userId === "string" && typeof state === "string" && typeof dataJson === "string") {
            _rt.notifyStateChange(kCmdTypePlayer, userId, state, dataJson, callback)
        } else {
            _rt.mgSdkLog("error", "userId=" + userId);
            _rt.mgSdkLog("error", "state=" + state);
            _rt.mgSdkLog("error", "dataJson=" + dataJson);
            let errMsg = "notifyPlayerStateChange userId state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog("error", errMsg);
        }

        _rt.mgSdkLog("info", "leave <==== notifyPlayerStateChange");
    };
}

// 3.APP==调用==>小游戏（公共接口）

// let handler = {
//     state: "on-app-state-xx-yy-zz",
//     onHandler: function(dataJson) {}
// };
// 4.APP==调用==>小游戏（透传通道接口）
if (!_rt.addApp2MgStateChangeHandler) {
    _rt.addApp2MgStateChangeHandler = function (handler) {
        _rt.mgSdkLog("info", "enter ====> addApp2MgStateChangeHandler");

        if (typeof handler === "object") {
            var state = handler.state;
            if (typeof state === "string" && state.length != 0) {
                _stateHandlerMap[state] = handler;
                _rt.mgSdkLog("info", "addApp2MgStateChangeHandler success");
            } else {
                _rt.mgSdkLog("error", "addApp2MgStateChangeHandler handler invalid");
            }
        } else {
            _rt.mgSdkLog("error", "addApp2MgStateChangeHandler handler invalid");
        }

        _rt.mgSdkLog("info", "leave <==== addApp2MgStateChangeHandler");
    };
}

if (!_rt.removeApp2MgStateChangeHandler) {
    _rt.removeApp2MgStateChangeHandler = function (handler) {
        _rt.mgSdkLog("info", "enter ====> removeApp2MgStateChangeHandler");

        if (typeof handler === "object") {
            var state = handler.state;
            if (typeof state === "string" && state.length != 0) {
                _stateHandlerMap[state] = null;
                _rt.mgSdkLog("info", "removeApp2MgStateChangeHandler success");
            } else {
                _rt.mgSdkLog("error", "removeApp2MgStateChangeHandler handler invalid");
            }
        } else {
            _rt.mgSdkLog("error", "removeApp2MgStateChangeHandler handler invalid");
        }

        _rt.mgSdkLog("info", "leave <==== removeApp2MgStateChangeHandler");
    };
}

if (!_rt.removeAllApp2MgStateChangeHandlers) {
    _rt.removeAllApp2MgStateChangeHandlers = function () {
        _rt.mgSdkLog("info", "enter ====> removeAllApp2MgStateChangeHandlers");

        _stateHandlerMap = {};

        _rt.mgSdkLog("info", "leave <==== removeAllApp2MgStateChangeHandlers");
    };
}


var _appStateMap = {};
if (!_rt.putState) {
    _rt.putState = function (state, dataJson) {
        _rt.mgSdkLog("info", "enter ====> putState");

        _appStateMap[state] = dataJson;

        _rt.mgSdkLog("info", "leave <==== putState");
    };
}

if (!_rt.getState) {
    _rt.getState = function (state) {
        _rt.mgSdkLog("info", "enter ====> getState");

        return _appStateMap[state];
//        if (callback != null && typeof callback.success == "function") {
//            callback.success(_appStateMap[state]);
//        } else {
//            _rt.mgSdkLog("info", "getState callback or callback.success invalid");
//        }

        _rt.mgSdkLog("info", "leave <==== getState");
    };
}

const _FSTMG = {
    login: _rt.login,
    expireCode: _rt.expireCode,
    getNetStatus: _rt.getNetStatus,
    getGameViewInfo: _rt.getGameViewInfo,
    vibrate: _rt.vibrate,
    getSDKInfo: _rt.getSDKInfo,
    getState: _rt.getState,
    notifyGameStateChange: _rt.notifyGameStateChange,
    notifyPlayerStateChange: _rt.notifyPlayerStateChange
};
if (!_rt.getFSTMG) {
    _rt.getFSTMG = function () {
        _rt.mgSdkLog("info", "enter ====> getFSTMG");
        return _FSTMG;
        _rt.mgSdkLog("info", "leave <==== getFSTMG");
    };
}


//let IFSMAPP = {
//     onNotifyNetStatus: function(dataJson) {
//     },
//     onUpdateCode: function(dataJson) {
//         console.log(dataJson);
//     },
//     onStateChange: function(state, dataJson) {
//     }
// };
var _FSMAPP = {};
if (!_rt.setFSMAPP) {
    _rt.setFSMAPP = function (fsmApp2Mg) {
        _rt.mgSdkLog("info", "enter ====> setFSMAPP");

        if (typeof fsmApp2Mg === "object") {
            _FSMAPP = fsmApp2Mg;
            let onUpdateCodeStateHandler = {
                state: kApp2MgStateUpdateCode,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onUpdateCode === "function") {
                        fsmApp2Mg.onUpdateCode(dataJson);
                    } else {
                        _rt.mgSdkLog("error", "setFSMAPP fsmApp2Mg.onUpdateCode not function");
                    }
                }
            };
            let onNotifyNetStatusStateHandler = {
                state: kApp2MgStateNotifyNetStatus,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onNotifyNetStatus === "function") {
                        fsmApp2Mg.onNotifyNetStatus(dataJson);
                    } else {
                        _rt.mgSdkLog("error", "setFSMAPP fsmApp2Mg.onNotifyNetStatus not function");
                    }
                }
            };
            let onStateChangeHandler = {
                state: kApp2MgStateStateChange,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onStateChange === "function") {
                        fsmApp2Mg.onStateChange(state, dataJson);
                    } else {
                        _rt.mgSdkLog("error", "setFSMAPP fsmApp2Mg.onStateChange not function");
                    }
                }
            };
            _rt.addApp2MgStateChangeHandler(onUpdateCodeStateHandler);
            _rt.addApp2MgStateChangeHandler(onNotifyNetStatusStateHandler);
            _rt.addApp2MgStateChangeHandler(onStateChangeHandler);
        } else {
            _rt.mgSdkLog("error", "setFSMAPP fsmApp2Mg invalid");
        }

        _rt.mgSdkLog("info", "leave <==== setFSMAPP");
    };
}

let _app2MgStateChangeNotify = function (state, dataJson) {
    _rt.mgSdkLog("info", "_app2MgStateChangeNotify state=" + state + " dataJson=" + dataJson);
    if (typeof state === "string" && state.length != 0) {
        _rt.putState(state, dataJson);
        let handler = _stateHandlerMap[state];
        if (handler != null) {
            if (typeof handler.onHandler === "function") {
                handler.onHandler(state, dataJson);
                return JSON.stringify({ "ret_code": 0, "ret_msg": "success" });
            } else {
                let errorMsg = "mg implement state=" + state + " but onHandler not ok";
                _rt.mgSdkLog("error", errorMsg);
                return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
            }
        } else {
            let handler2 = _stateHandlerMap[kApp2MgStateStateChange];
            if (handler2 != null) {
                if (typeof handler2.onHandler === "function") {
                    handler2.onHandler(state, dataJson);
                    return JSON.stringify({ "ret_code": 0, "ret_msg": "success" });
                } else {
                    let errorMsg = "mg implement state=" + state + " but onHandler not ok";
                    _rt.mgSdkLog("error", errorMsg);
                    return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
                }
            } else {
                let errorMsg = "mg not implement FSMAPP.onStateChange function";
                _rt.mgSdkLog("warning", errorMsg);
                return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
            }
        }
    } else {
        _rt.mgSdkLog("error", "_app2MgStateChangeNotify state Invalid");
        return JSON.stringify({ "ret_code": -1, "ret_msg": "state Invalid" });
    }
};