$(document).ready(function() {
    let that = this
    document.body.addEventListener('touchend', function(){ });
    var videoButton = function (context) {
        var ui = $.summernote.ui;
        // create button
        var button = ui.button({
            contents: '<i class="note-icon-video"><i>',
            //tooltip: '视频',
            //这里是我自己的点出时触发的事件
            click: function (e) {
                addVideo();
            },
            callback:function(){
                //initfunction(params); //这里的回调函数会在加载页面的时候直接执行
            }
        });
        return button.render();   //按钮渲染
    }
    var imageButton = function (context) {
        var ui = $.summernote.ui;
        // create button
        var button = ui.button({
            contents: '<i class="note-icon-picture"><i>',
            //tooltip: '图片',
            click: function (e) {
                addImg();
            },
            callback:function(){}
        });
        return button.render();   //按钮渲染
    }
    var searchButton = function (context) {
        var ui = $.summernote.ui;
        // create button
        var button = ui.button({
            contents: '<img class="searchError-img" src="../images/icon-search.png" style="width:17px;height:17px;display:none;"/>',
            click: function (e) {
                searchError()
            },
            callback:function(){}
        });
        return button.render();   //按钮渲染
    }
    var oH = $(window).height()-10;
    var oW = $(window).width();
    var oMaxLen = '';
    $('#summernote').summernote({
        height: 0,     // set editor height
        width: oW,         // set editor height
        disableDragAndDrop: true,
        //focus: true,                  // set focus to editable area after initializing summernote
        //功能图标改为中文
        lang: 'zh-CN',
        //预设内容
        placeholder: '请输入正文',
        toolbar:[
            ['style',['bold','italic','underline','clear','undo','redo']],
            ['pre-shipped',['myimage','myphoto','mysearch','fullscreen']],
        ],
        buttons: {
            myphoto: videoButton,     //自已定义的按钮函数
            myimage: imageButton,      //自已定义的按钮函数
            mysearch: searchButton
        },
        //回调函数
        callbacks:{
            //初始化
            onInit: function() {
                setNode('');
                $(document.querySelector('.note-btn.btn.btn-default.btn-sm.btn-fullscreen')).trigger('click');
                if (brower.version.android) {
                    window.upload.initComplete();
                } else if (brower.version.ios || brower.version.iPhone) {
                    //if(iosVersion() >= 8){
                        //window.webkit.messageHandlers.initComplete.postMessage(null);
                    //}else{
                        //initComplete();
                    //}
                }
            },
            //焦点
            onFocus: function() {
                //changeHeight();
            },
            onChange:function(){
                getLimitWord();
            }
        },
    });
    $('button').click(function(){
        //changeHeight();
    });
    $('.note-editor').click(function(){
        $('#summernote').summernote('enable');
    });

    // 隐藏纠错按钮，避免重绘
    $('.searchError-img').parent().hide()
    getPercentErrorCorrect().then(res=>{
        if(res){
            $('.searchError-img').show()
            $('.searchError-img').parent().show()
        }else{
            $('.searchError-img').parent().remove()
        }
    })
    const key = 'mBdviY4gInaA4ONQ',
    offset = 'tXtOfrUP5CuGSGme';
    getClientSign({key,offset}).then(res=>{
        window.clientSign = res
    })
});
var brower = {
    version: function() {
        var u = navigator.userAgent,
            app = navigator.appVersion;
        var userId = "";
        var appId = "";
        var arr = u.substring(u.search("userId/")).split(" ");
        var arr1 = u.substring(u.search("appId/")).split(" ");
        if(arr.length>1){
            for (var i = 0,len=arr.length; i<len; i++) {
                if(arr[i].indexOf("userId/")>-1){
                    userId = arr[i].replace("userId/","");
                    break;
                }
            };
        }else{
            userId = arr[0].replace("userId/","");
        }
        if(arr1.length > 1){
            for (var i = 0,len=arr1.length; i<len; i++) {
                if(arr1[i].indexOf("appId/")>-1){
                    appId = arr1[i].replace("appId/","");
                    break;
                }
            };
        }else{
            appId = arr1[0].replace("appId/","");
        }
        return { //移动终端浏览器版本信息
            trident: u.indexOf('Trident') > -1,
            //IE内核
            presto: u.indexOf('Presto') > -1,
            //opera内核
            webKit: u.indexOf('AppleWebKit') > -1,
            //苹果、谷歌内核
            gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') == -1,
            //火狐内核
            mobile: !! u.match(/AppleWebKit.*Mobile.*/),
            //是否为移动终端
            ios: !! u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),
            //ios终端
            android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1,
            //android终端或uc浏览器
            iPhone: u.indexOf('iPhone') > -1,
            //是否为iPhone或者QQHD浏览器
            iPad: u.indexOf('iPad') > -1,
            weixin: u.indexOf('MicroMessenger') > -1,
            //是否iPad
            webApp: u.indexOf('Safari') == -1,
            //是否web应该程序，没有头部与底部
            myApp: u.indexOf('pdmiryun') > -1, //在app里面打开
            userId : userId,
            appId : appId
        };
    }(),
    language: (navigator.browserLanguage || navigator.language).toLowerCase()
}
function iosVersion() {
    var agent = window.navigator.userAgent,
        start = agent.indexOf( 'OS ' );
 
    if( ( agent.indexOf( 'iPhone' ) > -1 || agent.indexOf( 'iPad' ) > -1 ) && start > -1 ){
        return window.Number( agent.substr( start + 3, 3 ).replace( '_', '.' ) );
    }
    return 0;
}
//视频资源（调用选择文件功能）
function addVideo(){
    if (brower.version.android) {
        window.upload.addVideo();
    } else if (brower.version.ios || brower.version.iPhone) {
        //if(iosVersion() >= 8){
            window.webkit.messageHandlers.addMDVideo.postMessage(null);
        //}else{
            //addVideo();
        //}
    }
}
//图片资源（调用选择文件功能）
function addImg(){
    if (brower.version.android) {
        window.upload.addImage();
    } else if (brower.version.ios || brower.version.iPhone) {
        //if(iosVersion() >= 8){
            window.webkit.messageHandlers.addMDImage.postMessage(null);
        //}else{
            //addImage();
        //}
    }
    
}
//编辑器插入视频
function setVideoNode(url,imgUrl){
    if(url){
        var $video = $('<video controls>')
            .attr('src', url)
            //.attr('width', '320')
            .attr('poster', imgUrl?imgUrl:'');
        $video.addClass('note-video-clip');
        $('#summernote').summernote('insertNode', $video[0]);
    }
}
//编辑器插入图片
function setImgNode(url){
    if(url){
        $('#summernote').summernote('insertImage', url);  
    }
}
//取编辑器内容
function getNode(){
    removeErrTag()
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    $('#placeBox').html(markupStr);
    var markupStr2 = $('#placeBox').text();
    if (brower.version.android) {
        window.upload.setContent(markupStr,markupStr2);
    }else{
        return [markupStr,markupStr2];
    }
}
//给编辑器设置内容
function setNode(str){
    $('#summernote').summernote('code',str);
}
window.onbeforeunload=function(){    
　　$('#summernote').summernote('destroy');
} 
function changeHeight(){
    if (brower.version.android) {
        
    } else if (brower.version.ios || brower.version.iPhone) {
        //window.webkit.messageHandlers.getMDkeyboardHeigh.postMessage(null);
    }
}
function getLimitWord(){
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    $('#placeBox').html(markupStr);
    var markupStr2 = $('#placeBox').text();
    var oL = parseInt(markupStr2.length) + parseInt((markupStr.split('<img')).length-1)+parseInt((markupStr.split('<video')).length-1);
    if(oL<=50000){
        $('#summernote').summernote('enable');
        oMaxLen = markupStr;
        $('#word-limit').html(oL+'/50000');
    }else{
        setNode(oMaxLen);
        $('#summernote').summernote('disable');
    }
}

/*注释一些相关内容*/
/*

    $("#summernote").summernote();  //初始化 summernote
    $('#summernote').summernote('destroy');  // 编辑器销毁
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    var markupStr = $('.summernote').eq(1).summernote('code');    //获取第几个编辑器内容
    $('#summernote').summernote('code', 'hello world');    //给指定的编辑器设置HTML内容
    $('#summernote').summernote('insertNode', $video);        //插入节点
    $('#summernote').summernote('insertText', 'saa');            //插入文本
    $('#summernote').summernote('disable');     //使编辑器处于不可用状态
    $('#summernote').summernote('enable');          //使编辑器从不可以转换到可用状态
    onImageUpload                                                   //重写图片上传方法

*/

function removeErrTag(){
    let _this = this
    let nodeList = null
    nodeList = $('.note-editable')[0].querySelectorAll('.err-tag');
    nodeList.length && Array.prototype.forEach.call(nodeList, function(node) {
        node.parentElement.replaceChild(document.createTextNode(node.innerText),node)
    })
}

function searchError(){
    if(window.searchError2){
        window.searchId = ""
        removeErrTag();
        window.searchError2.getErrorInfo();
    }else{
        window.searchError2 = new ErrorCode({
            editor: $('#summernote')
        })
    }
    errorDialog()
}
let observer = null,
    observer2 = null,
    contenteditable = false;
function errorDialog(status){
    const quickNode = document.getElementById('errorInfo')
    if(!observer){
        observer = new MutationObserver(getQuickStatus)
        observer.observe(quickNode,{
            attributes: true ,
        })
        function getQuickStatus(mutationRecords){
            if($('#errorInfo').css('display') == 'none'){
                $('#summernote').summernote('enable'); 
            }else{
                $('#summernote').summernote('disable'); 
            }
        }
    }
    const contenteditableStatusNode = document.getElementsByClassName('note-editable')[0]
    if(!observer2){
        observer2 = new MutationObserver(getContenteditableStatus)
        observer2.observe(contenteditableStatusNode,{
            attributes: true ,
        })
        function getContenteditableStatus(mutationRecords){
            if(window.searchId && mutationRecords[0].attributeName == 'contenteditable'){
                if($('.note-editable').attr('contenteditable') == 'true' && !contenteditable){
                    $('#errorInfo').addClass('hidden');
                    $('.error-tag').removeClass('hidden');
                    contenteditable = true
                }
                if($('.note-editable').attr('contenteditable') == 'false' && contenteditable){
                    $('#errorInfo').removeClass('hidden');
                    $('.error-tag').addClass('hidden');
                    contenteditable = false
                }
            }
        }
    }
    if(status){
        observer.disconnect()
        observer2.disconnect()
        $('#errorInfo,.error-tag').addClass('hidden');
    }else{
        if(observer){
            observer.observe(quickNode,{
                attributes: true ,
            })
        }
        if(observer2){
            observer2.observe(contenteditableStatusNode,{
                attributes: true ,
            })
        }
    }
}

/**
 * ASE 解密
 * @description 使用加密秘钥，对 需要解密的参数 进行解密
 * @param {string} content - 需要解密的参数
 * @param {string} params.key - 加密密钥（长度必须是 16 的整数倍）
 * @param {string} params.offset - 偏移量
 */
function aesDecryptParams(content, { key, offset }) {
    if (!key || !offset) {
        throw new Error('缺少加密相关配置');
    }

    // 密钥 - 从 UTF-8 编码 解析出原始字符串
    const keyUTF8 = CryptoJS.enc.Utf8.parse(key);
    // 偏移量（在此公司内是固定的） - 从 UTF-8编码 解析出原始字符串
    const offsetUTF8 = CryptoJS.enc.Utf8.parse(offset);

    const bytes = CryptoJS.AES.decrypt(content, keyUTF8, {
        iv: offsetUTF8,
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
    });

    return bytes.toString(CryptoJS.enc.Utf8);
}
// 获取签名信息
async function getClientSign({ developmentClientSign, key, offset }) {
    if (!xh.isMediaConvergenceXinhuaApp()) {
        return {
            sign: '',
            subDomain: '',
            userId:'',
            siteId:'',
            platform:brower.version.android ? 'android' : 'ios',
            // sign:'42f1be88681046e78fba2b6e10daa45a',
            // subDomain : 'http://www.testnewmedia.xinhuaapp.com',
            // userId : '1298729b971a48a59e7d6f4e839b63d5',
            // siteId : 'b5b45f34cedf466cae923971c5843b9f',
        };
    }
    function getClientSignInfo(){
        const clientSignInfo = new Promise(resolve => {
            xh.getClientSign({
                success(res) {
                    resolve(res);
                },
            });
        });
        return clientSignInfo
    }
    function getUserInfo(){
        const userInfo = new Promise(resolve => {
            xh.getUserInfo({
                success(res) {
                    resolve(res);
                },
            });
        });
        return userInfo
    }
    let allInfo = []
    await Promise.all([getClientSignInfo(),getUserInfo()]).then(res=>{
        allInfo = res
    })
    return {
        sign: this.aesDecryptParams(allInfo[0].cs, { key, offset }),
        subDomain: allInfo[0].subDomain,
        siteId:getValueFromUA('currentSiteId/'),
        userId:allInfo[1].id,
        platform: brower.version.android ? 'android' : 'ios',
    };
}
//获取用户标识
function getValueFromUA(key) {
    var arr = navigator.userAgent.substring(navigator.userAgent.search(key)).split(' '),
        id = '';

    if (arr.length > 0) {
        for (var i = 0, len = arr.length; i < len; i++) {
        if (arr[i].indexOf(key) > -1) {
            id = arr[i].replace(key, '');
            break;
        }
        }
    }
    return id;
}
// 获取纠错权限
async function getPercentErrorCorrect(){
    let percentErrorCorrect = await new Promise((resolve, reject) => {
        if(xh.percentErrorCorrect){
            xh.percentErrorCorrect({
                success(res) {
                    resolve(res.data);
                },
            });
        }
    })
    return percentErrorCorrect
}