$(document).ready(function() {
    document.body.addEventListener('touchend', function(){ });
    var videoButton = function (context) {
        var ui = $.summernote.ui;
        // create button
        var button = ui.button({
            contents: '<i class="note-icon-video"><i>',
            //tooltip: '视频',
            //这里是我自己的点出时触发的事件
            click: function (e) {
                addVideo();
            },
            callback:function(){
                //initfunction(params); //这里的回调函数会在加载页面的时候直接执行
            }
        });
          return button.render();   //按钮渲染
        }
        var imageButton = function (context) {
        var ui = $.summernote.ui;
        // create button
        var button = ui.button({
            contents: '<i class="note-icon-picture"><i>',
            //tooltip: '图片',
            click: function (e) {
                addImg();
            },
            callback:function(){}
        });
          return button.render();   //按钮渲染
    }
    var oH = $(window).height()-10;
    var oW = $(window).width();
    var oMaxLen = '';
    $('#summernote').summernote({
        height: 0,     // set editor height
        width: oW,         // set editor height
        disableDragAndDrop: true,
        //focus: true,                  // set focus to editable area after initializing summernote
        //功能图标改为中文
        lang: 'zh-CN',
        //预设内容
        placeholder: '',
        toolbar:[
            ['style',['bold','italic','underline','clear','undo','redo']],
            ['pre-shipped',['myimage','myphoto','fullscreen']],
        ],
        buttons: {
            myphoto: videoButton,     //自已定义的按钮函数
            myimage: imageButton      //自已定义的按钮函数
        },
        //回调函数
        callbacks:{
            //初始化
            onInit: function() {
                setNode('');
                $(document.querySelector('.note-btn.btn.btn-default.btn-sm.btn-fullscreen')).trigger('click');
                if (brower.version.android) {
                    window.upload.initComplete();
                } else if (brower.version.ios || brower.version.iPhone) {
                    //if(iosVersion() >= 8){
                        //window.webkit.messageHandlers.initComplete.postMessage(null);
                    //}else{
                        //initComplete();
                    //}
                }
            },
            //焦点
            onFocus: function() {
                //changeHeight();
            },
            onChange:function(){
                getLimitWord();
            }
        },
    });
    $('button').click(function(){
        //changeHeight();
    });
    $('.note-editor').click(function(){
        $('#summernote').summernote('enable');
    });
});
var brower = {
    version: function() {
        var u = navigator.userAgent,
            app = navigator.appVersion;
        var userId = "";
        var appId = "";
        var arr = u.substring(u.search("userId/")).split(" ");
        var arr1 = u.substring(u.search("appId/")).split(" ");
        if(arr.length>1){
            for (var i = 0,len=arr.length; i<len; i++) {
                if(arr[i].indexOf("userId/")>-1){
                    userId = arr[i].replace("userId/","");
                    break;
                }
            };
        }else{
            userId = arr[0].replace("userId/","");
        }
        if(arr1.length > 1){
            for (var i = 0,len=arr1.length; i<len; i++) {
                if(arr1[i].indexOf("appId/")>-1){
                    appId = arr1[i].replace("appId/","");
                    break;
                }
            };
        }else{
            appId = arr1[0].replace("appId/","");
        }
        return { //移动终端浏览器版本信息
            trident: u.indexOf('Trident') > -1,
            //IE内核
            presto: u.indexOf('Presto') > -1,
            //opera内核
            webKit: u.indexOf('AppleWebKit') > -1,
            //苹果、谷歌内核
            gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') == -1,
            //火狐内核
            mobile: !! u.match(/AppleWebKit.*Mobile.*/),
            //是否为移动终端
            ios: !! u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),
            //ios终端
            android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1,
            //android终端或uc浏览器
            iPhone: u.indexOf('iPhone') > -1,
            //是否为iPhone或者QQHD浏览器
            iPad: u.indexOf('iPad') > -1,
            weixin: u.indexOf('MicroMessenger') > -1,
            //是否iPad
            webApp: u.indexOf('Safari') == -1,
            //是否web应该程序，没有头部与底部
            myApp: u.indexOf('pdmiryun') > -1, //在app里面打开
            userId : userId,
            appId : appId
        };
    }(),
    language: (navigator.browserLanguage || navigator.language).toLowerCase()
}
function iosVersion() {
    var agent = window.navigator.userAgent,
        start = agent.indexOf( 'OS ' );
 
    if( ( agent.indexOf( 'iPhone' ) > -1 || agent.indexOf( 'iPad' ) > -1 ) && start > -1 ){
        return window.Number( agent.substr( start + 3, 3 ).replace( '_', '.' ) );
    }
    return 0;
}
//视频资源（调用选择文件功能）
function addVideo(){
    if (brower.version.android) {
        window.upload.addVideo();
    } else if (brower.version.ios || brower.version.iPhone) {
        //if(iosVersion() >= 8){
            window.webkit.messageHandlers.addMDVideo.postMessage(null);
        //}else{
            //addVideo();
        //}
    }
}
//图片资源（调用选择文件功能）
function addImg(){
    if (brower.version.android) {
        window.upload.addImage();
    } else if (brower.version.ios || brower.version.iPhone) {
        //if(iosVersion() >= 8){
            window.webkit.messageHandlers.addMDImage.postMessage(null);
        //}else{
            //addImage();
        //}
    }
    
}
//编辑器插入视频
function setVideoNode(url,imgUrl){
    if(url){
        var $video = $('<video controls>')
            .attr('src', url)
            //.attr('width', '100%')
            .attr('poster', imgUrl?imgUrl:'');
        $video.addClass('note-video-clip');
        $('#summernote').summernote('insertNode', $video[0]);
    }
}
//编辑器插入图片
function setImgNode(url){
    if(url){
        $('#summernote').summernote('insertImage', url);  
    }
}
//取编辑器内容
function getNode(){
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    $('#placeBox').html(markupStr);
    var markupStr2 = $('#placeBox').text();
    if (brower.version.android) {
        window.upload.setContent(markupStr,markupStr2);
    }else{
        return [markupStr,markupStr2];
    }
}
//给编辑器设置内容
function setNode(str){
    $('#summernote').summernote('code',str);
}
window.onbeforeunload=function(){    
　　$('#summernote').summernote('destroy');
} 
function changeHeight(){
    if (brower.version.android) {
        
    } else if (brower.version.ios || brower.version.iPhone) {
        //window.webkit.messageHandlers.getMDkeyboardHeigh.postMessage(null);
    }
}
function getLimitWord(){
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    $('#placeBox').html(markupStr);
    var markupStr2 = $('#placeBox').text();
    var oL = parseInt(markupStr2.length) + parseInt((markupStr.split('<img')).length-1)+parseInt((markupStr.split('<video')).length-1);
    if(oL==0){
        $('.note-editable').removeClass('hidePlace');
    }else{
        $('.note-editable').addClass('hidePlace');
    }
    if(oL<=10000){
        $('#summernote').summernote('enable');
        oMaxLen = markupStr;
        $('#word-limit').html(oL+'/10000');
    }else{
        setNode(oMaxLen);
        $('#summernote').summernote('disable');
    }
}

/*注释一些相关内容*/
/*

    $("#summernote").summernote();  //初始化 summernote
    $('#summernote').summernote('destroy');  // 编辑器销毁
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    var markupStr = $('.summernote').eq(1).summernote('code');    //获取第几个编辑器内容
    $('#summernote').summernote('code', 'hello world');    //给指定的编辑器设置HTML内容
    $('#summernote').summernote('insertNode', $video);        //插入节点
    $('#summernote').summernote('insertText', 'saa');            //插入文本
    $('#summernote').summernote('disable');     //使编辑器处于不可用状态
    $('#summernote').summernote('enable');          //使编辑器从不可以转换到可用状态
    onImageUpload                                                   //重写图片上传方法

*/



