function ErrorCode(option) {
    this.option = {};
    Object.assign(this.option, option);
    this.init();
}

var messagebox = {
    // 显示消息提醒
    show: function (message) {
        var box = document.getElementById("message_box");
        var text = document.getElementById("message_text");
        text.innerHTML = message;
        box.style.display = 'block';
        // 5秒后自动隐藏
        setTimeout(function() {
            box.style.display = 'none';
        }, 3000);
    },
};

var fn = ErrorCode.prototype;
fn.init = function(){
    let editorFrame = null
    this.createdDialogDom();
    // this.showDialog();
    this.createResultDom();
    this.initEvent();
    this.getErrorInfo();
}

function iframePostMessage(params, frame) {
    (frame || window.top).postMessage(params, "*");
}

fn.showDialog = function(){
    $('.mask-page').removeClass('hidden').css('z-index',1200);
    $('#errorCodeDialog .btn-check').addClass('checked');
    $('#errorCodeDialog .btn-radio').removeClass('checked');
    $('#errorCodeDialog .btn-radio').eq(0).addClass('checked');
    $('#errorCodeDialog').removeClass('hidden');
}
fn.hideMask = function(){
    $('.mask-page').addClass('hidden').css('z-index',2);
}
fn.createdDialogDom = function(){
    var str,
        testTypes = [
            {
                code: 'chkEng',
                lable: '英文拼写错误',
            },{
                code: 'userErr',
                lable: '自定义',
            },{
                code: 'leader',
                lable: '领导人和重点词',
            },{
                code: 'politicIssue',
                lable: '政治性问题',
            },{
                code: 'usedWords',
                lable: '曾用词',
            },{
                code: 'htmlTag',
                lable: 'html标记',
            },{
                code: 'leaderSort',
                lable: '领导人排序',
            },{
                code: 'matchDots',
                lable: '标点符号',
            }],
        checkTypes = [
            {
                code: '0',
                lable: '快速校对',
                describe: '只标记肯定性错误，不标记怀疑性错误，校对速度最快，误报很少'
            },{
                code: '1',
                lable: '正常校对',
                describe: '校对效果介于快速级别和严格级别之间。校对时在标记肯定性错误之外，还会标记一些怀疑性错误，可能会产生一些误报，但是漏报较少。'
            },{
                code: '2',
                lable: '严格校对',
                describe: '可以标记能检查的所有肯定性错误和怀疑性错误。由于查错范围的增大，可能误报会略多一些。'
            }];
    str = '<div class="dialog-title"><span>智能检测</span><span class="dialog-close layui-icon layui-icon-close"></span></div>';
    str += '<div class="dialog-content"><div class="choice-content"><p class="choice-content-title">检测项目：</p><ul  class="choice-content-list" id="testTypes">';
    testTypes.forEach(function(o,i){
        str += '<li class="item-check"><span class="btn-check checked" data-type="'+o.code+'"></span><span>'+o.lable+'</span></li>'
    })
    str += '</ul></div><div class="choice-content"><p class="choice-content-title">校对类型</p><ul  class="choice-content-list" id="checkType">';
    checkTypes.forEach(function(o,i){
        str += '<li class="item-radio"><span class="btn-radio'+(i==0 ? ' checked' : '')+'" data-type="'+o.code+'"></span><span>'+o.lable+'</span><span class="btn-help"><p class="hover-des">'+o.describe+'</p></span></li>'
    })
    str += '</ul></div></div>';
    str += '<div class="dialog-footer"><span class="btn-yes">立即检测</span><span class="btn-cancle">取消</span></div>';
    var _dialog = document.createElement('DIV');
    _dialog.setAttribute('class','dialog-of-editor hidden');
    _dialog.setAttribute('id','errorCodeDialog');
    // _dialog.innerHTML = str;
    document.body.appendChild(_dialog);
    $('#errorCodeDialog .dialog-close').click();
}
fn.createResultDom = function(){
    var str;
    str = '<div class="right-box-title">智能纠错结果<img class="icon_close" src="../images/icon_close.png"/><span class="right-box-close layui-icon layui-icon-close">收起</span></div>'
        + '<div class="error-box">发现<i class="red error-num"></i>处错误'
        + '<span class="btn-ignore">全部忽略</span><span class="btn-change">全部修改</span></div>'
        + '<ul class="right-box-content" id="errorInfoList"></ul>'
        + '<p class="right-box-footer"><span class="btn-recheck">重新检测</span></p>'
    var _result = document.createElement('DIV');
    _result.setAttribute('class','right-box hidden');
    _result.setAttribute('id','errorInfo');
    _result.innerHTML = str;
    document.body.appendChild(_result);
    var _errorTag = document.createElement('DIV');
    _errorTag.setAttribute('class','error-tag hidden');
    _errorTag.innerHTML = '智能纠错结果<span class="error-num"></span><img style="width:12px;height:12px" src="../images/icon-arrow.png"/>'
    document.body.appendChild(_errorTag);
}
fn.initEvent = function(){
    var _this = this;
    $('.dialog-close').click(function(){
        $(this).parents('.dialog-of-editor').addClass('hidden');
        _this.hideMask();
    })
    $('.btn-check').click(function(e){
        if($(e.target).hasClass('checked')) $(e.target).removeClass('checked');
        else $(e.target).addClass('checked');
    })
    $('.btn-radio').click(function(e){
        if($(e.target).hasClass('checked')) $(e.target).removeClass('checked');
        else $(e.target).addClass('checked').parent('.item-radio').siblings('.item-radio').find('.btn-radio').removeClass('checked');
    })
    $('.btn-yes').click(function(){//todo
        $('#errorCodeDialog .dialog-close').click();
        _this.getErrorInfo();
    })
    $('.btn-cancle').click(function(){
        $('#errorCodeDialog .dialog-close').click();
    })
    //全部忽略
    $('.btn-ignore').click(function(){
        $('#errorInfoList').html('');
        _this.removeErrTag();
        $('.right-box-btns .error-num').html('0');
        $('.error-tag .error-num').html('0');
        $(this).addClass('hide');
        $('.btn-change').addClass('hide');
    })
    //全部修改
    $('.btn-change').click(function(){
        $('#errorInfoList .error-item').each(function(i,n){
            if(!$(n).hasClass('right')){
                var right = $(n).find('.error-item-btns').attr('data-right');
                if(right && right.length){
                    var pos = $(n).find('.error-item-btns').attr('data-pos');
                    var changed = _this.changeError(pos,right);
                    changed && $(n).find('.error-item-img').attr("class","error-item-img right").attr('src','../images/icon-right.png');
                    changed && $(n).find('.error-item-btns').remove();
                }
            }
        })
        $(this).addClass('hide');
        $('.btn-ignore').addClass('hide');
    })
    $('.btn-recheck').click(function(){
        window.searchId = ""
        _this.removeErrTag();
        _this.getErrorInfo();
    })
    $('.right-box-close,.icon_close').click(function(){
        $('#errorInfo').addClass('hidden');
        $('.error-tag').removeClass('hidden');
    })
    $('.error-tag').click(function(){
        $(this).addClass('hidden');
        $('#errorInfo').removeClass('hidden');
        $('.error-tag').css('top','').css('left','')
    })
    $('#errorInfoList').delegate('.error-item','click', function(e){//忽略
        var right = $(this).find('.error-item-btns').attr('data-right');
        var pos = $(this).find('.error-item-btns').attr('data-pos');
        if(!pos)return
        if($(e.target).hasClass('error-item')){
            $('.note-editable').find('.err-tag[data-pos="'+pos+'"]')[0].scrollIntoView({behavior: "smooth", block: "center"})
            return false
        }
        if($(e.target).hasClass('error-item-change')){
            var changed = _this.changeError(pos,right);
            changed && $(e.target).parents('.error-item').find('.error-item-img').attr("class","error-item-img right").attr('src','../images/icon-right.png');;
            changed && $(e.target).parent('.error-item-btns').remove();
            return false
        }
        if($(e.target).hasClass('error-item-ignore')){
            _this.changeError(pos) && $(e.target).parents('.error-item').remove();
            return false
        }
    })
    $('.note-editable').delegate('.err-tag','click',function(e){
        _this.showErrorBtn(e,this)
    })
    
    var element = document.getElementsByClassName('error-tag')[0];
    var startX, startY,elementX,elementY;
    var isDragging = false;
    document.addEventListener('touchmove', function(e) {
        if (isDragging) {
            var x = elementX + e.touches[0].clientX - startX;
            var y = elementY + e.touches[0].clientY - startY;
            element.style.left = x + 'px';
            element.style.top = y + 'px';
        }
    });

    document.addEventListener('touchend', function(e) {
        isDragging = false;
    });
    element.addEventListener('touchstart', function(e) {
        // e.preventDefault();
        isDragging = true;
        startX = e.touches[0].clientX;
        startY = e.touches[0].clientY;
        elementX = parseInt(window.getComputedStyle(element).left);
        elementY = parseInt(window.getComputedStyle(element).top);
    });

}
fn.openLoading = function(){
    // $('.mask-page').removeClass('hidden').css('z-index',1200).addClass('loading');
    xh.updateClientEditorLoading({
        status:true
    })
    $('#errorInfo,.error-tag').addClass('hidden');
}
fn.closeLoading = function(){
    // $('.mask-page').addClass('hidden').css('z-index',2).removeClass('loading');
    xh.updateClientEditorLoading({
        status:false
    })
}
fn.compare= function(property){
    return function(obj1,obj2){
        var value1 = obj1[property];
        var value2 = obj2[property];
        return value1 - value2;     // 升序
    }
}
fn.getErrorInfo = function(){
    // $(this.option.editor.document.getElementById('editorErrorTip')).remove();
    var checkTxt = $('#placeBox').text();
    if(!checkTxt.length){
        messagebox.show('请输入文本内容')
        return
    }
    var _this = this;
    this.openLoading();
    var params = {
        txt: checkTxt,
    }
    let signParams = this.getSignRequestParams(params)
    $.ajax({
        url: window.clientSign.subDomain + '/draftlibapi/check/checkArticlePercent',
        type: 'post',
        dataType: 'json',
        data: signParams,
        success: function (res) {
            window.searchId = res.checkId
            if (res.list && res.list.length> 0) {
                let arr = []
                res.list.forEach(item=>{
                    item.esCheckErrorDetails.forEach((it)=>{
                        arr.push(it)
                    })
                })
                let newArr = arr.sort(_this.compare('pos'))
                if(_this.option.editor.errorFlag != 1){
                    _this.option.editor.errorFlag = 1;
                }
                $('.btn-ignore,.btn-change').removeClass('hide');
                // $('.checkedWord-num').html(res.wordsCount);
                $('.error-num').html(arr.length);
                $('#errorInfo').removeClass('hidden');
                let aaa = ""
                let divNode = document.createElement('DIV');
                divNode.innerHTML = $('#summernote').summernote('code');
                // res.list.forEach(arr=>{
                    var str='',errorLevels=['right','error','warn','error'];
                    let errorArr=[];
                    arr.forEach(function (o,i) {
                        var hasSuggest = o.suggest[0] && o.suggest[0].length;
                        var _o = {
                            pos: o.pos,
                            level: 1,
                            rightInfo: hasSuggest ? _this.getRightWord(o.suggest[0],o.error) : {right:'',sug:'',type:1},
                            errTxt: o.error,
                            endPos: (o.pos+o.error.length)
                        }
                        errorArr.push(_o);
                        str += '<li class="error-item"><img class="error-item-img error" src="../images/icon-warn.png"/>';
                        //0：显示：原词+修改后内容  1：显示：原词+修改建议  2：显示：修改建议
                        switch (_o.rightInfo.type) {
                            case 0:
                                str += '<span>【'+o.error+'】' + '建议修改为' + '【'+_o.rightInfo.right+'】</span>'
                                    + '<div class="error-item-btns" data-pos="'+o.pos+'" data-right="'+_o.rightInfo.right+'">'
                                    + '<span class="error-item-change">修改</span><span class="error-item-ignore">忽略</span></div>'
                                    + '</li>';
                                break;
                            case 1:
                                if(o.error == _o.rightInfo.sug){
                                    str += '<span>【'+o.error+'】疑似有误</span>'
                                        + '<div class="error-item-btns" data-pos="'+o.pos+'">'
                                        + '<span class="error-item-ignore">忽略</span></div>'
                                        + '</li>';
                                }else{
                                    str += '<span>【'+o.error+'】' + '修改提示为' + '【'+_o.rightInfo.sug+'】</span>'
                                        + '<div class="error-item-btns" data-pos="'+o.pos+'">'
                                        + '<span class="error-item-ignore">忽略</span></div>'
                                        + '</li>';
                                }
                                break;
                            case 2:
                                str += _o.rightInfo.sug
                                    + '<div class="error-item-btns" data-pos="'+o.pos+'">'
                                    + '<span class="error-item-ignore">忽略</span></div>'
                                    + '</li>';
                                break;
                            default:
                                str += '【'+o.error+'】' + '建议修改为' + '【'+o.suggest[0]+'】'
                                    + '<div class="error-item-btns" data-pos="'+o.pos+'" data-right="'+o.suggest[0]+'">'
                                    + '<span class="error-item-change">修改</span><span class="error-item-ignore">忽略</span></div>'
                                    + '</li>';
    
                        }
                        _this.renderErrorEditor([_o],divNode);
                    })
                    aaa += str
                // })
                $("#errorInfoList").html(aaa);
                fn.closeLoading();
                errorDialog()
            }else{
                messagebox.show('内容无错误')
                fn.closeLoading()
                errorDialog(true)
            }
        },
        error: function () {
            messagebox.show('系统错误')
            fn.closeLoading();
        }
    })
}
//处理纠错建议
fn.getRightWord = function(txt, oldTxt){
    var info = {
        right: '',
        sug: txt.replace(/\[/g,'【').replace(/\]/g,'】'),
        type: 0 //0：显示：原词+修改后内容  1：显示：原词+修改建议  2：显示：修改建议
    }
    if(/^\<.*>$/.test(txt)){ //<政治问题>
        info.type = 1
        return info
    }
    if(/\(.*\+.*\)/.test(txt)){//（+） 是建议
        info.type = 1
        return info
    }
    if(/\]应在\[/.test(txt)){// 检测词顺序
        info.type = 2
        return info
    }
    if(/^(缺少成对){1}/.test(txt)){//'缺少成对' 重复
        info.right = txt;
        info.type = 0;
        return info
    }
    if(/.*(标点符号)/.test(txt)||/.*(日期可能)/.test(txt)){//标点符号确少成对
        info.type = 2
        return info
    }
    if(txt === oldTxt){//两次相同
        info.right = txt;
        info.type = 1
        return info
    }
    info.right = txt;
    info.type = 0;
    return info
}
/* 添加纠错标记 */
fn.renderErrorEditor = function(dateArr,divNode) {
    console.log(divNode);
    var _this = this;
    var textLen=0, dateArrIndex=0,txtPos=0;
    let lis = null
    console.log($('#summernote').summernote('code'));
    (function markErrorWord(_d){
        if(_d.nodeType == 3){//文本
            var txt = getNodeTxt(_d)
            if(txt.length && dateArr[dateArrIndex]){
                var l1 = txtPos, l2 = txtPos+txt.length, o = dateArr[dateArrIndex],
                    sp = o.pos, ep = o.endPos;
                if(txt.match(o.errTxt) ){//node内匹配成功
                    // if(txtPos+txt.match(o.errTxt).index == sp){}
                    var handleResult = handleErrorNode(txt,_d,sp-l1,ep-l1);
                    handleResult ? markErrorWord(handleResult) : true;
                }else if(sp <= l1 && ep > l2){//node全部匹配成功
                    handleErrorNode(txt,_d,0);
                }else if(sp < l1 && ep > l1 && ep <= l2){//node部分匹配成功
                    var handleResult = handleErrorNode(txt,_d, 0, ep-l1);
                    handleResult ? markErrorWord(handleResult) : true;
                }else{
                    txtPos = l2;
                }
            }
            $('#summernote').summernote('code',divNode);
        }else if(_d.nodeType == 1){//元素
            Array.prototype.forEach.call(_d.childNodes, function(ele) {
                markErrorWord(ele);
            })
        }
    })(divNode);
   
    function handleErrorNode(txt,txtNode, startP, endP)  {
        var pEle = txtNode.parentElement,tArr = [], signErr = '>>>>>>err-tag';
        if (startP > 0){
            tArr.push(txt.substring(0,startP));
        }
        if(endP == undefined){
            tArr.push(signErr+txt.substring(startP));
        }else{
            tArr.push(signErr+txt.substring(startP,endP));
            tArr.push(txt.substring(endP));
        }
        tArr = tArr.filter(function(t,i){
            return t.length;
        })
        var nodeArr = [];
        tArr.forEach(function(t,i){
            var node;
            if(new RegExp(signErr).test(t)){
                var o = dateArr[dateArrIndex];
                node = document.createElement('SPAN');
                node.setAttribute('data-righttype',o.rightInfo.type);
                node.setAttribute('data-pos',o.pos);
                node.setAttribute('class','err-tag err-tag-'+o.level);
                node.innerText = t.replace(signErr,'');
                if(o.rightInfo.errTxt !== o.rightInfo.right){
                    node.setAttribute('data-righttxt',(o.rightInfo.type ? o.rightInfo.sug : o.rightInfo.right));
                }else{
                    node.setAttribute('data-righttxt','');
                }

            }else{
                node = document.createTextNode(t)
            };
            i ? $(node).insertAfter(nodeArr[nodeArr.length-1]) : pEle.replaceChild(node,txtNode);
            nodeArr.push(node)
        })
        endP == undefined ? false : ++dateArrIndex;
        if (nodeArr[nodeArr.length-1].nodeType == 3) {
            txtPos = txtPos + txt.length - tArr[tArr.length-1].length;
            return nodeArr[nodeArr.length-1]
        }else{
            txtPos += txt.length;
            return false
        }
    }
    function getNodeTxt(contentTxt){
        var reg = new RegExp(('\u200B'),'g');
        if (typeof(contentTxt) === 'string') {
            contentTxt = contentTxt.trim();  // 获取原始的文本信息，去掉前后的空白字符\
        }
        if (typeof(contentTxt) === 'object') {
            contentTxt = contentTxt.textContent
        }        
        return contentTxt.replace(reg, '').replace(/\u00a0/g, ' ')
    }
    function reErrorText(txt){
        var _span = document.createElement('SPAN');
        _span.innerText = txt;
        _span.style.color = 'red';
        return _span;
    }
};
/* 去除纠错标标记 */
fn.removeErrTag = function(){
    let _this = this
    let nodeList = null
    nodeList = $('.note-editable')[0].querySelectorAll('.err-tag');
    nodeList.length && Array.prototype.forEach.call(nodeList, function(node) {
        node.parentElement.replaceChild(document.createTextNode(node.innerText),node)
    })
}
/* 纠错修改 */
fn.changeError = function(pos,str){
    let _this = this
    let nodeList = $('.note-editable').find('.err-tag[data-pos="'+pos+'"]')
    if(!nodeList.length){
        messagebox.show('未检测到修改内容')
        return false
    }
    Array.prototype.forEach.call(nodeList, function(node,i) {
        if(i==0){
            node.parentElement.replaceChild(document.createTextNode(str ? str : node.innerText),node)
        }else{
            node.remove()
        }
    })
    var markupStr = $('#summernote').summernote('code');    //获取编辑器内容
    $('#placeBox').html(markupStr);
    var n = Number($('.error-tag .error-num').html())-1;
    $('.error-tag .error-num').html(n);
    return true;
}
/* 编辑器内显示纠错操作按钮 */
fn.showErrorBtn = function (e,dom) {
    e.stopPropagation();
    var _this = this;
    let pos = $(dom).attr('data-pos')
    $('#errorInfo').removeClass('hidden')
    $('.error-tag').addClass('hidden')
    $('#errorInfo').find('.error-item-btns[data-pos="'+pos+'"]')[0].scrollIntoView({behavior: "smooth", block: "center"})
    $('#errorInfo').find('.error-item-btns[data-pos="'+pos+'"]').parent().addClass('activeScroll')
    setTimeout(() => {
        $('#errorInfo').find('.error-item-btns[data-pos="'+pos+'"]').parent().addClass('normalScroll')
        setTimeout(() => {
            $('#errorInfo').find('.error-item-btns[data-pos="'+pos+'"]').parent().removeClass('activeScroll normalScroll')
        }, 500);
    }, 500);
}

/** 生成签名信息 */
fn.getSignRequestParams = function (params) {
    const requestParams = { ...window.clientSign,...params };
    const currentTimeMillis = new Date().getTime();
    requestParams.currentTimeMillis = currentTimeMillis;
    if (window.clientSign && window.clientSign.sign) {
        const paramsArr = Object.values(requestParams);
        // 加入客户端签名
        // paramsArr.push('42f1be88681046e78fba2b6e10daa45a');
        paramsArr.push(window.clientSign.sign);
        paramsArr.sort();
        const signature = hex_md5(paramsArr.join(''));
        requestParams.signature = signature;
    }
    return requestParams;
}