uniform sampler2D baseTex;
#ifdef GL_ES
precision mediump float;
#endif

uniform float time;
uniform vec2 resolution;

uniform float posX;
uniform float posY;

const float PI = 3.1415926535897932;
varying vec2 v_texcoord;
varying vec4 v_color;

const float intensity = 0.14;
const float wave = 8.0;
const float range = 0.15;

void main()
{
    vec2 center = vec2(posX, posY);
    vec2 p = v_texcoord;
    vec2 dv = center - p;
    dv = dv * vec2(resolution.x / resolution.y, 1);
    float dis = sqrt(dv.x * dv.x + dv.y * dv.y);
    
    if (dis <= time + range && dis >= time - range && dis > 0.1) {
        
        float ecart = (dis - time); // value between -0.02 & 0.02
        
        float powEcart = 1.0 - pow(abs(ecart * wave), intensity); // value between -1 & 1 (because 0.02 * 50 = 1)
        
        float ecartTime = ecart * powEcart; // value between -0.02 & 0.02
        
        vec2 diff = normalize(p - center); // get the direction
        
        vec2 newTexCoord = p + (diff * ecartTime);
        
        gl_FragColor = texture2D(baseTex, newTexCoord);
    } else {
        discard;
    }
}
