vec4 HeatMapColor(float value, float minValue, float maxValue)
{
    #define HEATMAP_COLORS_COUNT 6
    vec4 colors[HEATMAP_COLORS_COUNT] =
    {
        vec4(0.00, 0.00, 0.32, 1.00),
        vec4(0.00, 0.64, 0.64, 1.00),
        vec4(0.00, 1.00, 0.00, 1.00),
        vec4(1.00, 1.00, 0.00, 1.00),
        vec4(1.00, 0.64, 0.00, 1.00),
        vec4(1.00, 0.00, 0.00, 1.00),
    };

    float ratio = (HEATMAP_COLORS_COUNT-1.0) * 
            saturate((value - minValue) / (maxValue - minValue));
    float indexMin = floor(ratio);
    float indexMax = min(indexMin + 1, HEATMAP_COLORS_COUNT - 1);
    return lerp(colors[indexMin], colors[indexMax], ratio - indexMin);
}
