#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D baseTex;

uniform float time;
uniform vec2 resolution;
varying vec2 v_texcoord;

const float uFreqY = 20.0;
const float uFreqX = 10.0;
const float uSpeed = 3.0;
const float uAmplitude = 0.003;


void main()
{
    vec2 uv = gl_FragCoord.xy / resolution.xy;
    gl_FragColor = texture2D(baseTex,v_texcoord + vec2(sin(uFreqY*uv.y + uFreqX*uv.x + uSpeed*time) * uAmplitude));
    
//    vec2 uv = v_texcoord;
//    
//    uv.y += (cos((uv.y + (time * 0.04)) * 45.0) * 0.0019) +
//    (cos((uv.y + (time * 0.1)) * 10.0) * uAmplitude);
//    
//    uv.x += (sin((uv.y + (time * 0.07)) * 15.0) * 0.0029) +
//    (sin((uv.y + (time * 0.1)) * 15.0) * uAmplitude);
//    
//    
//    gl_FragColor = texture2D(baseTex, uv);
}
