#ifdef GL_ES
precision mediump float;
#endif

#define PI 3.1415926535897932

varying vec2 v_texcoord0;
varying vec2 v_texcoord1;
varying vec4 v_color;

uniform sampler2D baseTex;
uniform sampler2D distortTex;

uniform vec2 resolution;
uniform vec2 direction;
uniform float time;

float intensity = 20.0;

void
main() {
    float distort = texture2D(distortTex, v_texcoord1).a;
    if (distort < 0.2)
    {
        gl_FragColor = texture2D(baseTex, v_texcoord0);

        return;
    }
    
    vec4 color = vec4(0.0);
    color += texture2D(baseTex, v_texcoord0 + (direction * distort * intensity / resolution));
    
    if ( color.r == 0.0 ) {
        gl_FragColor = texture2D(baseTex, v_texcoord0);
        return;
    }
    
    gl_FragColor = color;
    return;
}
