(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["hybridReady"] = factory();
	else
		root["hybridReady"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

__webpack_require__(1);

var PATH = {
  Android: '/app/hybrid/cordova/platform/android/cordova.js',
  iOS: '/app/hybrid/cordova/platform/ios/cordova.js'
};

var appRegular = {
  Android: /(ydh-android)/i,
  iOS: /(ydh-iOS)/i,
  brandAndroid: /(ydh-brand-android)/i,
  brandIOS: /(ydh-brand-iOS)/i
};

var hybridReady = {
  // getQueryString: function(name){
  //     let _self = this;
  //     let reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
  //     let result = window.location.search.substr(1).match(reg);
  //     if(result!=null){
  //       return unescape(result[2]);
  //     }
  //     return null;
  // },
  isYdhBrandApp: function isYdhBrandApp() {
    var ua = navigator.userAgent.toLowerCase();

    var isBrandAndroid = appRegular.brandAndroid.test(ua),
        isBrandIOS = appRegular.brandIOS.test(ua);
    if (isBrandAndroid) {
      return 'Android';
    } else if (isBrandIOS) {
      return 'iOS';
    }
    return false;
  },
  isYDHApp: function isYDHApp() {
    var ua = navigator.userAgent.toLowerCase();
    var isYdhAndroid = appRegular.Android.test(ua),
        isYdhIOS = appRegular.iOS.test(ua);
    if (isYdhAndroid) {
      return 'Android';
    } else if (isYdhIOS) {
      return 'iOS';
    }
    return false;
  },
  getAppVersion: function getAppVersion() {
    var version = {};
    var ua = navigator.userAgent.toLowerCase();
    var isYdhAndroid = appRegular.Android.test(ua),
        isYdhIOS = appRegular.iOS.test(ua),
        isBrandAndroid = appRegular.brandAndroid.test(ua),
        isBrandIOS = appRegular.brandIOS.test(ua);

    var REGS = {
      ydhAndroid: /ydh-android\/[\d._]+/gi,
      ydhIOS: /ydh-iOS\/[\d._]+/gi
    };
    function getVersion(browser) {
      var detail = '0',
          major = 0; //, minor = 0, patch=0
      var reg = REGS[browser];
      var v_info = ua.match(reg);
      if (v_info) {
        detail = (v_info + '').replace(/[^0-9|_.]/gi, '').replace(/_/gi, '.'); //得到版本号4.2.2  //得到版本号9.3.2或者9.0
        major = parseInt(detail.split('.')[0]); // 得到版本号第一位
      }
      return { detail: detail, major: major };
    }

    if (isYdhAndroid) {
      version = getVersion('ydhAndroid');
    } else if (isYdhIOS) {
      version = getVersion('ydhIOS');
    }
    return { version: version, isYdhAndroid: isYdhAndroid, isYdhIOS: isYdhIOS, isBrandAndroid: isBrandAndroid, isBrandIOS: isBrandIOS };
  },
  setScript: function setScript() {
    var _self = this;
    var YDHApp = _self.isYDHApp();
    var res = 'https://res.dinghuo123.com';
    var path = res + PATH[YDHApp];
    var scriptElement = document.createElement('script');
    scriptElement.type = 'text/javascript';
    scriptElement.src = path;
    var head = document.getElementsByTagName('head')[0];
    // console.log('scriptElement',path);
    head.appendChild(scriptElement);
  },
  getReady: function getReady(callback) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { needSetScript: true };

    var _self = this;
    if (opts.needSetScript) {
      _self.setScript();
    }
    if (callback) {
      document.addEventListener('deviceready', function () {
        callback();
      }, false);
    } else {
      return new Promise(function (resolve) {
        document.addEventListener('deviceready', function () {
          resolve();
        }, false);
      });
    }
  },
  demo: function demo() {
    window.Hybrid('biz.getData', { dataType: 'nodeCode' }).then(function () {
      alert('suc');
    }).catch(function () {
      alert('error');
    });
  }
};

exports.default = hybridReady;
module.exports = exports['default'];

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

/*
 * @Author: max.zhang
 * @Date: 2017-12-08 14:16:38
 * @Last Modified by: max.zhang
 * @Last Modified time: 2018-05-25 16:42:55
 */
/*
 接口文档地址 http://blog.csdn.net/RuihanChen/article/details/50561460
 */

var DefaultOpts = {
  'device.showConfirm': {
    label: ['确认', '取消']
  },
  'device.showPreloader': {
    text: '加载中'
  },
  'biz.uploadImages': {
    multiple: true,
    max: 9
  },
  'biz.navigation.setVisibility': {
    visibility: 1
  },
  'tab.setVisibility': {
    visibility: 1
  }
};

/**
 * @param  {string} name
 * opts:
 * @param  {any} ...others
 * cb
 * @param  {func} success
 * @param  {func} error
 * 成功和失败都有两种触发形式，promise实际上没有用，后面干掉。
 * 注意promise在多次success/error触发的时候，只会被触发一次，因此不适用，建议直接用第三个参数传回去。
 */
/*
 调用案例：
 要调用客户端 ydh.biz.getData 的方法，
 window.Hybrid('biz.getData',{
 dataType:'nodeCode'
 },{success:()=>{},error:()=>{}})
 .then((res)=>{})
 .catch((err)=>{})
 */

var commonSuccess = null,
    commonError = null;

window.Hybrid = function (name, opts) {
  var cb = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return new Promise(function (resolve, reject) {
    try {
      var FUNC = eval('window.ydh.' + name);
      console.log('被调用的函数：', name);
      console.log('对应的参数：', DefaultOpts[name], opts);
      FUNC(function (res) {
        console.log('调用函数-' + name + '【成功】', res);
        commonSuccess && commonSuccess(res);
        cb.success && cb.success(res);
        resolve(res);
      }, function (err) {
        console.warn('调用函数' + name + '【失败】，失败原因：', err);
        commonError && commonError(err);
        cb.error && cb.error(err);
        reject(err || '调用失败，请稍后再试');
      }, _extends({}, DefaultOpts[name] || {}, opts || {}));
    } catch (e) {
      alert(name + '设备接口调用失败！');
      console.warn(name + '设备接口调用失败！', '参数:', opts);
      reject(false);
    }
  });
};

//设置公用的回调，以及可以修改默认设置（浅拷贝）。
window.Hybrid.setOptions = function () {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  opts.success && (commonSuccess = opts.success);
  opts.error && (commonError = opts.error);

  //不用Object.assign避免外面文件要依赖pollify
  if (opts.defaultOpts) {
    opts.defaultOpts = _extends({}, DefaultOpts, opts.defaultOpts);
  }
};

/***/ })
/******/ ]);
});