window.language = {
    "zh":{
        login__input_username:"请输入手机号码/用户名",
        login__input_password:"请输入密码",
        login__a_getpassword:"找回密码",
        login__input_verifyocode:"请输入右侧字符",
        login__btn_login:"登 录",
        login__btn_logining:"正在登录",
        login__btn_login_loading:"数据载入中...",
        login__btn_login_retry:"重新登录",
        login__p_trial:"立即体验",
        login__p_register:"注册",
        login__p_freelogin:"返回首页",
        login__tips_empty_username:"账号不能为空！",
        login__tips_empty_password:"密码不能为空！",
        login__tips_login_error:"账号或密码错误！",
        login__tips_verify:"请输入验证码！",
        login__tips_verify_error:"验证码输入错误！",
        login__tips_user_disabled:"您的账号被禁用或者被删除, 请联系厂商管理员，谢谢!",
        login__tips_limit5:"连续输错密码五次,请30分钟后再试!",
        global__tips_http_error:"网络请求失败，请稍后再试！",
        login__tips_empty_phone:"请输入正确手机号！",
        login__input_phone:"请输入手机号码"
    },
    "en":{
        login__input_username:"Please enter username",
        login__input_password:"Please enter password",
        login__a_getpassword:"Forget Password",
        login__input_verifyocode:"Please enter character",
        login__btn_login:"Login",
        login__btn_logining:"Logging in",
        login__btn_login_loading:"Data Loading ...",
        login__btn_login_retry:"Relogin",
        login__p_trial:"Experience now",
        login__p_register:"Register",
        login__p_freelogin:"Back Home",
        login__tips_empty_username:"Account cannot be empty!",
        login__tips_empty_password:"Password cannot be empty!",
        login__tips_login_error:"Incorrect account or password!",
        login__tips_verify:"Please enter verification code!",
        login__tips_verify_error:"Incorrect verification code!",
        login__tips_user_disabled:"Your account is disabled or deleted, please contact the manufacturer administrator, thank you!",
        login__tips_limit5:"Five passwords were entered incorrectly five times, please try again in 30 minutes!",
        global__tips_http_error:"The network request failed. Please try again later!",
        login__tips_empty_phone:"Incorrect phone num!",
        login__input_phone:"Please enter phone num"
    }
};
var lang = (navigator.language.toLocaleLowerCase().substring(0,2) === 'zh' ? 'zh' : 'en');

var loginErrorCount = 0;
var sso = 'https://sso.dinghuo123.com';
var corp = 'https://corp.dinghuo123.com';
var agent = 'https://agent.dinghuo123.com';
var getHybridReady = window.hybridReady;
var ydhApp = getHybridReady.isYDHApp();
var ydhBrandApp = getHybridReady.isYdhBrandApp();
var localStorageUserName='ydh-user-name';

//定制
var brandDbid;
var groupType;
var subDbid;
var accessToken;
var isLogout;
var groupAccount;
var themeColor = '0dbdcd';

//轮询时间相关
var timer;
var count = 0;  //总ms
var sleep = 100;
var timeout = 500;

//设置点击事件
if (ydhApp) {
    getHybridReady.getReady(function () {
        init();
    });
    
} else {
    init();
}

function setLang(){
    $("[i18nlang]").each(function(i,v){
         var strlan = $(v).attr("i18nlang");
         if(strlan==='login__input_username'){
           if(groupType==='2'){
             strlan='login__input_phone';
           }
         }
        var showLanguage =window.language[lang][strlan];
        if(v.nodeName==='INPUT'){
          if(v.hasAttribute('placeholder')){
            $(v).attr('placeholder',showLanguage);
          }else{
            $(v).val(showLanguage);
          }
        }else if(v.nodeName==='SPAN' || v.nodeName==='DIV' || v.nodeName==='P' || v.nodeName==='I' || v.nodeName==='A'){
           v.innerHTML = showLanguage;
        }

    });
}

//写死高度（避免键盘弹出导致高度变化）
function setHeight(){
    $('.body').height(window.innerHeight);
};

document.addEventListener('readystatechange', function () {
    if (document.readyState === 'complete') {
      //iphone 5c 需要在complete后并setTimeout才能获取到正确的window.innerHeight
      setTimeout(setHeight);
      clearInterval(timer);
    }
});
  // ready 或达到500ms之前轮询设置rem，保证渲染过程中不会出现 innerHeight 变化
timer = setInterval(function () {
    setHeight();
    count += sleep;
    if (count > timeout) {
        clearInterval(timer);
    }
}, sleep);
setHeight();
//end 设置高度

//一些基本方法
function openMain(url) {
    if (ydhApp) {
        window.Hybrid('biz.ui.openMainActivity', {
            url: url
        });
    } else {
        window.location.href = url;
    }
}

//新开的界面都需要重新设置状态栏颜色
function openPage(url) {
    if (ydhApp) {
        window.Hybrid('biz.ui.openPage', {
            url: url
        });
    } else {
        window.location.href = url;
    }
}

function setLocalStorage(name,val){
    try{
        localStorage.removeItem(name);   //据说ios设置重复值有bug，所以每次设置前先清除一下吧。
        localStorage.setItem(name, val);
    }
    catch(e){
        console.error(e);
    }
    
}

function getLocalStorage(name){
    return window.localStorage && localStorage.getItem(name);
}

//初始化
function init(){
    setEvent();
    getThemeColor();
    getBrandDbid();
    getStoreInfo();
    getLogoutData();
    setAttributes();
}

//获取定制主题色
function getThemeColor()
{
    if(ydhBrandApp){
        themeColor = $('#loginBgColor').css("background-color");
        themeColor = colorRGB2Hex(themeColor).slice(1);
    }
}

function colorRGB2Hex(color) {
    var rgb = color.split(',');
    var r = parseInt(rgb[0].split('(')[1]);
    var g = parseInt(rgb[1]);
    var b = parseInt(rgb[2].split(')')[0]);
    var hex = "#" + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
    return hex;
}

//设置状态栏色值
function setAttributes(){
    window.Hybrid('biz.statusBar.setAttributes',{
          backgroundColor: '#' + themeColor
    });
}

//品牌定制获取dbid
function getBrandDbid(){
    if(ydhBrandApp){
        //定制自定义head-logo
        $('#brand-header-logo').attr('src', "./brand/logo.png");
        
        window.Hybrid('biz.getBrandDbid',{},{
            success:function(data){
                brandDbid = data.brandDbid;
                groupType = data.groupType;
                setRegistShow();
                setUserName();
                setLang();
             },
            error:function(data){
                setUserName();
                setLang();
            }
        });
    }else{
         setUserName();
         setLang();
    }
}
function getStoreInfo(){
    if(ydhBrandApp){
        window.Hybrid('biz.getStoreInfo',{},{
            success:function(data){
                subDbid = data.subDbid;
            }
        });
    }
}
function getLogoutData(){
    if(ydhBrandApp){
        window.Hybrid('biz.getLogoutData',{},{
            success:function(data){
                isLogout = data.isLogout;
            }
        });
    }
}

//设置以前的用户名
function setUserName(){
    function setValue(userName){
        $('#userName').val(userName);
        $('#userNameDelete').show();
    }

    if(ydhApp){
        window.Hybrid('biz.getAccountData',{},{
            success:function(data){
                if(groupType==='2'){
                  accessToken = data.accessToken
                  groupAccount = data.groupAccount
                  data && data.groupAccount && setValue(data.groupAccount);
                }else{
                  data && data.userName && setValue(data.userName);
                }
            }
        });
    }else{
        var userName = getLocalStorage(localStorageUserName);
        userName && setValue(userName);
    }
}

//设置点击事件
function setEvent() {

    //处理回弹
    $("input").on("blur", function () {
        var currentPosition, timer;
        var speed = 1;
        timer = setInterval(function () {
            currentPosition = document.documentElement.scrollTop || document.body.scrollTop;
            currentPosition -= speed;
            window.scrollTo(0, currentPosition);//页面向上滚动
            currentPosition += speed;
            window.scrollTo(0, currentPosition);//页面向下滚动
            clearInterval(timer);
        }, 100);
    })

    //监听回车
    $('body').on('keyup', '.js-enter',function(evt){
        if (evt && evt.keyCode === 13) {
            //执行操作
            $('#login').trigger('click');
        }
    });

    //删除按钮
    $('#userNameDelete').click(function(){
        $('#userName').val('');
        $(this).hide();
    });

    //监听输入框输入。
    $('#userName').on('keyup',function(evt){
        if(evt.target.value !== ''){
            $('#userNameDelete').show();
        }else{
            $('#userNameDelete').hide();
        }
    });

    //验证码
    $('#verifyCodeImg').click(function(){
        $(this).attr('src','https://sso.dinghuo123.com/verifyCode?t'+new Date().getTime());
    });
    
    //返回商城首页
    $("#backHome").click(function(e){
        e.preventDefault();
        window.Hybrid('biz.ui.freeLogin');
    });
    
    //注册
    $('#goRegister').click(function(e){
        e.preventDefault();
        var userName = '';
        if(!isLogout){
          userName = groupAccount;
        }
        if(ydhApp === 'iOS'){
            if(ydhBrandApp && brandDbid.length > 0){
                if(groupType==='2'){
                   openPage(corp + '/alert/customer/customer?platform=iOS&action=registerByDefDevice&id=39&dbid=' + brandDbid + '&groupDbid=' + brandDbid+ '&groupAccount=' + (userName||"") +  '&subDbid=' + (subDbid||"") + '&groupType=' + groupType + '&themeColor=' + themeColor + '#!p=registerForm');
                }else{
                   openPage(corp + '/alert/customer/customer?platform=iOS&action=registerByDefDevice&id=39' + '&groupDbid=' + brandDbid + '&themeColor=' + themeColor + '&dbid=' + brandDbid + '#!p=registerForm');
                }
            }else{
                openPage(sso + '/app/apply?s=699100100010100001&utm_source=appstore&utm_campaign=iOS&platform=iOS&utm_content=app&utm_term=');
            }
        }else if(ydhApp === 'Android'){
            if(ydhBrandApp && brandDbid.length > 0){
                if(groupType==='2'){
                   openPage(corp + '/alert/customer/customer?platform=Android&action=registerByDefDevice&id=39&dbid=' + brandDbid + '&groupDbid=' + brandDbid+ '&groupAccount=' + (userName||"") +  '&subDbid=' + (subDbid||"") + '&groupType=' + groupType + '&themeColor=' + themeColor + '#!p=registerForm');
                }else{
                   openPage(corp + '/alert/customer/customer?platform=Android&action=registerByDefDevice&id=39&dbid=' + brandDbid + '&groupDbid=' + brandDbid + '&themeColor=' + themeColor + '#!p=registerForm');
                }
            }else{
                window.Hybrid('biz.getChannelValue').then(function(d){
                    openPage(sso + '/app/apply?s=' + d.channelID + '&platform=Android&utm_source=' + d.channelName + '&utm_campaign=az&utm_content=app&utm_term=');
                }).catch(function(err){
                    err && tips(err);
                });
            }
        }else {
                tips('请在app中打开')
        }
    });
    
    //立即体验
    $('#go-experience').click(function(e){
        e.preventDefault();
        openPage('https://agent.dinghuo123.com/app/enter.jsp');
    });
    //找回密码
    $('#findPassword').click(function(e){
        e.preventDefault();
        openPage(sso + '/forgetpwd/index?' + 'themeColor=' + themeColor);
    });

    $('#login').val(window.language[lang].login__btn_login);
    $('#login').click(function (e) {
        e.preventDefault();
        var $_this = $(this);
        var userName = $.trim($('#userName').val());
        if(groupType==='2'){
          if(!(/^1[3456789]\d{9}$/.test(userName))){
              tips(window.language[lang].login__tips_empty_phone);
              return false;
          }
        }else{
          if (userName === '') {
              tips(window.language[lang].login__tips_empty_username);
              return false;
          };
        }

        var password = $.trim($('#password').val());
        if (password === '') {
            tips(window.language[lang].login__tips_empty_password);
            return false;
        };
        var verifyCode = $.trim($('#verifyCode').val());

        var postData = {};
        postData.userName = userName;
        postData.password = password;
        postData.verfCode = verifyCode;
                  
        //品牌定制登录添加dbid
        if(ydhBrandApp){
        if(groupType==='2'){
            postData.dbid = subDbid;
        }else{
            postData.dbid = brandDbid;
        }
            postData.groupDbid = brandDbid;
        }
                      
        $.ajax({
            // url: "https://api.dinghuo123.com/oauth2/token?grant_type=client_credentials&client_id=2124574&client_secret=3sfX3HJX484gXY&scope=basic",
            url: sso + "/v2/app/token",
            data: postData,
            aysnc: false,
            dataType: "jsonp",
            beforeSend: function () {
                $_this.text(window.language[lang].login__btn_logining).attr("disabled", true);
            },
            success: function (responseText) {
                var response = JSON.parse(responseText);
                var data = response.data;
                function go(){
                    if (data.isPassPortAccount) { //公用的账号直接去切换账号页面
                       if(ydhBrandApp){
                            var gType=groupType||''
                            var gAccount=postData.userName||''
                            openPage(sso + '/app/accountList?jwt=' + jwtToken + '&groupDbid=' + brandDbid + '&groupType=' + gType + '&groupAccount=' + gAccount  + '&limitClient=1&dbid=' + postData.dbid);
                       }else{
                            openPage(sso + '/app/accountList?jwt=' + jwtToken);
                       }
                    }
                    else {
                        //跳管理端
                        if (userType === 1) {
                            openMain(corp + '/app/index.html');
                        }
                        //跳订货端
                        else {
                            openMain(agent + '/app/index.html');
                        }
                    }
                }
                if (response.code === 200) {
                    var jwtToken = data.jwtToken;
                    var userType = data.userType;
                    /*
                        isPassPortAccount : true-公用账号，false-子账号。（公用即通行证账号）
                        enabledPassPort ：如果是子账号，这个子账号是否开通了通行证账号。
                        hasMoreAccount ：是否只有一个账号
                    */
                    //存储用户名
                    setLocalStorage(localStorageUserName, userName);
                    //给app保存token
                    ydhApp && window.Hybrid(
                        'biz.setAccountData',
                        {
                            accessToken: jwtToken,
                            accountType: userType === 1 ? 'corp' : 'agent',
                            expiresIn: data.expries_in || data.expires_in,   //后端 ri 和 ir 拼写问题
                            userName: data.userName,
                            groupAccount: postData.userName,
                            dbid: data.dbid || 0
                        },
                        {
                            success:function(){
                               go();
                            },
                            error:function(err){
                                tips(err);
                            }
                        }
                    );
                    !ydhApp && go();
                    $_this.removeAttr("disabled");
                }else{
                    var message = response.message;
                    if(message == "login_error"){
                        loginErrorCount++;
                        tips(window.language[lang].login__tips_login_error);
                        if(loginErrorCount >= 3){
                            $(".verify-code-box").show();
                            $('#btnBox').addClass('btn-box-near');
                        }
                    }else if(message == "need_verfCode"){
                        tips(window.language[lang].login__tips_verify);
                        $(".verify-code-box").show();
                        $('#btnBox').addClass('btn-box-near');
                    }else if(message == "wrong_verfCode"){
                        tips(window.language[lang].login__tips_verify_error);
                    }else if(message == "user_disabled"){
                        tips(window.language[lang].login__tips_user_disabled);
                    }else if(message.indexOf("limit") != -1){
                        tips(window.language[lang].login__tips_limit5);
                    }else{
                        tips(message);
                    }
                    
                    $_this.removeAttr("disabled").val(window.language[lang].login__btn_login_retry);
                }
            },
            error: function (responseText) {
                tips(window.language[lang].global__tips_http_error);
                $_this.removeAttr("disabled").val(window.language[lang].login__btn_login_retry);
            }
        });
    });
}

function setRegistShow(){
    $.ajax({
        url:"https://corp.dinghuo123.com/public/queryAppLoginPageSetting?"+"dbid="+brandDbid,
        aysnc: true,
        dataType: "json",
        success: function (response) {
                var data = response.data;
                if (!data.showReg) {  //品牌定制注册按钮是否显示
                    $('#brand-go-register').removeClass('brand-show');
            }
        },error: function (responseText) {
            $('#brand-go-register').removeClass('brand-show');
        }
    });
}
