cordova.define("com.ircloud.ydh.hybrid.BizPlugin", function(require, exports, module) {
/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   <a target=_blank href="http://www.apache.org/licenses/LICENSE-2.0">http://www.apache.org/licenses/LICENSE-2.0</a>
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
var exec = require('cordova/exec');
               
/**
 * Provides access to notifications on the device.
 */
module.exports = {
       /**
        * Causes the device to beep.
        * On Android, the default notification ringtone is played "count" times.
        *
        * @param {Integer} type       The Toast type.
        */
       shareContent: function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "shareContent", [content]);
       },
       call:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "call", [content]);
       },
       sendMessage:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "sendMessage", [content]);
       },
       scanCode:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "scanCode", [content]);
       },
       uploadImages:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "uploadImages", [content]);
       },
       uploadFile:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "uploadFile", [content]);
       },
       uploadTakePicture:function(successCallback,errorCallback,content){
                   exec(successCallback, errorCallback, "BizPlugin", "uploadTakePicture", [content]);
              },
       saveImage:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "saveImage", [content]);
       },
       orderBluetoothPrint:function(successCallback,errorCallback,content){
            exec(successCallback, errorCallback, "BizPlugin", "orderBluetoothPrint", [content]);
       },
       copyText:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "copyText", [content]);
       },
       toDownloadAttachment:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "toDownloadAttachment", [content]);
       },
       onAttachmentListStatus:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "onAttachmentListStatus", [content]);
       },
       setAccountData:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "setAccountData", [content]);
       },
       setStoreInfo:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "setStoreInfo", [content]);
       },
       getLogoutData:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "getLogoutData", [content]);
       },
       getStoreInfo:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "getStoreInfo", [content]);
       },
       getAccountData:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "getAccountData", [content]);
       },
       updateToken:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "updateToken", [content]);
       },
       getGesturePasswordStatus:function(successCallback,errorCallback,content){
           exec(successCallback, errorCallback, "BizPlugin", "getGesturePasswordStatus", []);
       },
       getChannelValue:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "getChannelValue", []);
       },
       openService:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "openService", []);
       },
       setGrowingCSData:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "setGrowingCSData", [content]);
       },
       evokeKeyboard:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "evokeKeyboard", [content]);
       },
       getBrandDbid:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "getBrandDbid", [content]);
       },
       openBrowser:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "openBrowser", [content]);
       },
       getAPPMold:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "getAPPMold", [content]);
       },
       launchMiniProgram:function(successCallback,errorCallback,content){
       exec(successCallback, errorCallback, "BizPlugin", "launchMiniProgram", [content]);
       },
  };
});
