var app = {
    initialize: function() {

        app.bindEvents();
    },
    bindEvents: function() {
        document.addEventListener('deviceready', app.onDeviceReady, false);
        // app.onDeviceReady();
    },
    checkAndroidPermissions: function(callback) {
        if (device.platform !== 'Android') {
            callback();
            return;
        }

        var permissions = cordova.plugins.permissions;
        var arr = [
            permissions.CAMERA,
            permissions.RECORD_AUDIO,
            permissions.MODIFY_AUDIO_SETTINGS
        ];

        permissions.hasPermission(arr, function(status) {
            if (status.hasPermission) {
              callback();
                return;
            }

            permissions.requestPermissions(arr, function(status) {
                if (status.hasPermission) {
                  callback();
                    return;
                }
                alert('Please manually enable camera and microphone permissions.');
            }, function() {
                alert('Please manually enable camera and microphone permissions.');
            });
        }, function() {
            alert('Please manually enable camera and microphone permissions.');
        });
    },
    onDeviceReady: function() {
    }
};

app.initialize();
// export default app;
