(function() {
	var Privacy = /*@__PURE__*/ (function(Component) {
		function Privacy(props) {
			Component.call(this, props);
			this.data = {
				title: "用户协议与隐私政策",
				content: "",
				nodes:
					'（1）《隐私政策》中关于个人设备用户信息的收集与使用说明。<br/>（2）《隐私政策》中与第三方SDK类服务商数据共享，相关信息收集和使用说明。<br/>用户协议和隐私政策说明:<br/>可阅读完整的<span class="login_xieyi"><a href="https://app1.kszhiji.com/app_android_xieyi.html">《用户协议》</a></span>和<span class="login_yinsi"><a href="https://app1.kszhiji.com/app_android_yinsi.html">《隐私政策》</a></span>。如您同意以上内容，请点击“同意”开始使用我们的产品和服务。',
				disagree: "不同意",
				agree: "同意并继续",
				isTipMode: false
			};
		}

		if (Component) Privacy.__proto__ = Component;
		Privacy.prototype = Object.create(Component && Component.prototype);
		Privacy.prototype.constructor = Privacy;
		Privacy.prototype.apiready = function() {};
		Privacy.prototype.disagree = function() {
			api.closeWidget({silent: true});
		};
		Privacy.prototype.agree = function() {
			api.agreedPrivacy();
		};
		Privacy.prototype.onInteract = function(e) {
			var url = e.detail.url;
			api.openWin({
				name: "moments_win", //需要跳转的页面名字
				url: url,
				rect: {
					x: 0,
					y: 0,
					w: "auto",
					h: "auto"
				}
			});
		};
		Privacy.prototype.render = function() {
			var this$1 = this;
			return apivm.h(
				"view",
				{class: "page"},
				apivm.h(
					"view",
					{class: "cover"},
					apivm.h(
						"view",
						{class: "box"},
						apivm.h("text", {class: "title"}, this.data.title),
						apivm.h(
							"scroll-view",
							{class: "content-area", bounces: false},
							apivm.h("text", {class: "content"}, this.data.content),
							apivm.h("rich-text", {
								class: "policy-area",
								nodes: this.data.nodes,
								"link-text-color": "#6487df",
								"user-select": true,
								oninteract: this.onInteract
							})
						),
						apivm.h(
							"view",
							{class: "btn-area"},
							apivm.h(
								"text",
								{
									class: "login_span_modalDlg_ok",
									onclick: function(event) {
										if (this$1.agree) {
											this$1.agree();
										} else {
											agree();
										}
									}
								},
								this.data.agree
							),
							apivm.h(
								"text",
								{
									class: "login_span_modalDlg_nook",
									onclick: function(event) {
										if (this$1.disagree) {
											this$1.disagree();
										} else {
											disagree();
										}
									}
								},
								this.data.disagree
							)
						)
					)
				)
			);
		};

		return Privacy;
	})(Component);
	Privacy.css = {
		".login_span_modalDlg_ok": {
			textAlign: "center",
			lineHeight: "40px",
			backgroundColor: "#10b51b",
			color: "#fff",
			margin: "0px 20px",
			marginTop: "30px",
			borderRadius: "20px"
		},
		".login_span_modalDlg_nook": {
			textAlign: "center",
			lineHeight: "40px",
			margin: "0px 20px",
			marginTop: "20px",
			borderRadius: "20px"
		},
		".login_yinsi,.login_xieyi": {
			color: "blue",
			textDecoration: "underline",
			fontWeight: "600"
		},
		".page": {
			width: "100%",
			height: "100%",
			backgroundImage: "url(../../image/1080x1920.png)",
			backgroundSize: "100% 100%",
			backgroundRepeat: "no-repeat"
		},
		".cover": {
			justifyContent: "center",
			alignItems: "center",
			width: "100%",
			height: "100%",
			backgroundColor: "rgba(0, 0, 0, 0.6)"
		},
		".box": {
			width: "85%",
			maxWidth: "360px",
			minHeight: "167px",
			backgroundColor: "white",
			borderRadius: "14px",
			paddingBottom: "20px"
		},
		".title": {
			margin: "10px 15px",
			color: "black",
			fontWeight: "600",
			textAlign: "center",
			whiteSpace: "normal",
			padding: "10px 0px"
		},
		".content-area": {minHeight: "90px", overflow: "scroll"},
		".content": {
			margin: "0 20px",
			color: "black",
			fontSize: "14px",
			whiteSpace: "normal",
			textAlign: "justify",
			lineHeight: "20px"
		},
		".policy-area": {
			margin: "0px 20px",
			whiteSpace: "normal",
			fontSize: "14px",
			lineHeight: "20px",
			textAlign: "justify"
		},
		".btn-area": {borderTop: "0.5px solid #f5f5f5", marginTop: "20px"},
		".disagree": {
			flex: "1",
			textAlign: "center",
			lineHeight: "40px",
			color: "#555"
		},
		".disagree:active": {opacity: "0.8"},
		".line": {width: "0.5px", height: "28px", backgroundColor: "#f5f5f5"},
		".agree": {
			flex: "1",
			textAlign: "center",
			lineHeight: "40px",
			color: "#EE2233"
		},
		".agree:active": {opacity: "0.8"}
	};
	apivm.define("privacy", Privacy);
	apivm.render(apivm.h("privacy", null), "body");
})();
