package com.dingyue.statistics.activitylife


import android.app.Activity
import android.app.Application
import android.content.Context
import android.os.Bundle
import java.util.*

/**
 * Created by yuchao on 2018/11/14
 * Mail yuchao_liu@dingyuegroup.cn
 * Desc Activity生命周期监听
 */
class ActivityLifecycleHelper private constructor() : Application.ActivityLifecycleCallbacks {

    override fun onActivityCreated(activity: Activity?, savedInstanceState: Bundle?) {
    }

    override fun onActivityStarted(activity: Activity?) {
    }

    override fun onActivityResumed(activity: Activity?) {
        if (activity == null) return
        synchronized(activityNames) {
            if (CRASH_SIZE <= activityNames.size) activityNames.removeAt(0)
            activityNames.add(getName(activity))
        }
    }

    override fun onActivityPaused(activity: Activity?) {
    }

    override fun onActivityStopped(activity: Activity?) {}

    override fun onActivitySaveInstanceState(activity: Activity?, outState: Bundle?) {
    }

    override fun onActivityDestroyed(activity: Activity?) {
    }

    companion object {

        private val singleton: ActivityLifecycleHelper by lazy(LazyThreadSafetyMode.SYNCHRONIZED) {
            ActivityLifecycleHelper()
        }

        private val activityNames: MutableList<String> by lazy { LinkedList<String>() }

        private const val CRASH_SIZE = 15

        fun build(): ActivityLifecycleHelper {
            return singleton
        }


        fun getActivityNames(): String {
            val sb = StringBuffer()
            synchronized(activityNames) {
                val size = activityNames.size
                for (i in 0 until size) {
                    sb.append(activityNames[i])
                    if (i != size - 1)
                        sb.append("->")
                }
            }
            return sb.toString()
        }

        private fun getName(context: Context): String {
            val contextString = context.toString()
            return contextString.substring(contextString.lastIndexOf(".") + 1, contextString.indexOf("@"))
        }
    }

}
