package com.dingyue.statistics.application;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.util.Log;

import com.dingyue.statistics.exception.NonMainThreadException;
import com.dingyue.statistics.utils.ProcessUtil;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/**
 * @author 170303
 * @date 2019/3/14 19:36
 * @email hn_yangxiaowei@163.com
 * @desc
 */
//public class ApplicationWrapper implements ApplicationVisibilityMonitor{
public class ApplicationWrapper{

    private static final String TAG = "ApplicationWrapper";

    private static ApplicationWrapper instance = new ApplicationWrapper();
    private Application application;

    @MainThread
    private ApplicationWrapper() {
//        this.init(null);
    }

    @MainThread
    public void init(Application application) throws NonMainThreadException {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            Log.e(TAG, "请确保在主线程进行初始化");
            throw new NonMainThreadException("请确保在主线程进行初始化");
        }

        if (null == this.application) {
            this.application = application;
        }

//        if (null != this.application && ProcessUtil.isMainProcess(this.application)) {
//            this.application.registerActivityLifecycleCallbacks(lifecycleCallbacks);
//        }

    }

    public static ApplicationWrapper getInstance() {
        return instance;
    }

    private int mMainThreadId = android.os.Process.myTid();
    /**
     * 主线程Handler
     */
    private static Handler mMainThreadHandler = new Handler(Looper.getMainLooper());

    /**
     * 获取主线程ID
     */
    public int getMainThreadId() {
        return mMainThreadId;
    }

    /**
     * 获取主线程的handler
     */
    public Handler getMainThreadHandler() {
        return mMainThreadHandler;
    }


//    private int activeActivitiesCount = 0;
//    private Stack<Activity> activities = new Stack<>();
//    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks() {
//        @Override
//        public void onActivityCreated(Activity activity, Bundle savedInstanceState) { }
//
//        @Override
//        public void onActivityStarted(Activity activity) {
//            activeActivitiesCount += 1;
//            if (activeActivitiesCount == 1) {
//                onApplicationToForeground();
//            }
//
//            activities.addElement(activity);
//        }
//
//        @Override
//        public void onActivityResumed(Activity activity) { }
//
//        @Override
//        public void onActivityPaused(Activity activity) { }
//
//        @Override
//        public void onActivityStopped(Activity activity) {
//            activeActivitiesCount -= 1;
//            if (activeActivitiesCount == 0) {
//                onApplicationToBackground();
//            }
//        }
//
//        @Override
//        public void onActivitySaveInstanceState(Activity activity, Bundle outState) { }
//
//        @Override
//        public void onActivityDestroyed(Activity activity) {
//            activities.remove(activity);
//        }
//    };

//    @Override
//    public void onApplicationToForeground() {
//        for (ApplicationVisibilityMonitor avm : monitors) {
//            if (null == avm) {
//                continue;
//            }
//            avm.onApplicationToForeground();
//        }
//    }

//    @Override
//    public void onApplicationToBackground() {
//        for (ApplicationVisibilityMonitor avm : monitors) {
//            if (null == avm) {
//                continue;
//            }
//            avm.onApplicationToBackground();
//        }
//    }

//    public boolean isApplicationInBackground() {
//        return activeActivitiesCount == 0;
//    }
//
//    public boolean isApplicationInForeground() {
//        return activeActivitiesCount > 0;
//    }
//
//    public void clearAllActivities() {
//        while (!activities.isEmpty()) {
//            Activity activity = activities.pop();
//            activity.overridePendingTransition(-1, -1);
//            activity.finish();
//        }
//    }

//    private List<ApplicationVisibilityMonitor> monitors = new LinkedList<>();
//
//    public void registerMonitor(ApplicationVisibilityMonitor avm) {
//        if (null == avm) {
//            return;
//        }
//        if (monitors.contains(avm)) {
//            return;
//        }
//        monitors.add(avm);
//    }

//    public void unRegisterMonitor(ApplicationVisibilityMonitor avm) {
//        if (null == avm) {
//            return;
//        }
//        monitors.remove(avm);
//    }

    public void release() {
//        if (null != application) {
//            application.unregisterActivityLifecycleCallbacks(lifecycleCallbacks);
//        }
//        monitors.clear();
//        if (null != mMainThreadHandler) {
//        }
    }

    public Application getApplication() {
        return this.application;
    }

    public Context getContext() {
        return null == this.application ? null : this.application.getApplicationContext();
    }

    public boolean isInited() {
        return this.getContext() != null;
    }
}
