package com.dingyue.statistics.client

import android.text.TextUtils

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/15 17:37
 * @email hn_yangxiaowei@163.com
 * @desc
 */
object SimpleBook : Validator, AdValidator, PVValidator {


    @JvmStatic
    fun build(): SimpleBook {
        return this
    }

    var bookId: String? = null
    //图书来源
    var sourceIds: String? = null
    //渠道号
    var channel: String? = null
    var chapterId: String? = null
    var chapterPages: Int = 0
    //开始阅读时间
    var startReadTimeMill: Long = 0
    //是否听书标识
    var isListen: Boolean = false

    fun withBookId(bookId: String): SimpleBook {
        this.bookId = bookId
        return this
    }

    fun withSourceIds(sourceIds: String): SimpleBook {
        this.sourceIds = sourceIds
        return this
    }

    fun withChannel(channel: String): SimpleBook {
        this.channel = channel
        return this
    }

    fun withChapterId(chapterId: String): SimpleBook {
        this.chapterId = chapterId
        return this
    }

    fun withChapterPages(pages: Int): SimpleBook {
        this.chapterPages = pages
        return this
    }

    fun withStartReadTime(startReadTimeMill: Long): SimpleBook {
        this.startReadTimeMill = startReadTimeMill
        return this
    }

    fun withIsListen(isListen: Boolean): SimpleBook {
        this.isListen = isListen
        return this
    }

    override fun validate(): Boolean {
        return (!TextUtils.isEmpty(bookId)
                && !TextUtils.isEmpty(chapterId)
                && chapterPages > 0)
    }

    /**
     * 针对广告事件[曝光|点击]
     * @return
     */
    override fun validateForAd(): Boolean {
        return !TextUtils.isEmpty(bookId) && !TextUtils.isEmpty(chapterId)
    }

    override fun validateForPV(): Boolean {
        return (!TextUtils.isEmpty(bookId)
                && !TextUtils.isEmpty(chapterId)
                && startReadTimeMill > 0
                && chapterPages > 0)
    }
}
