package com.dingyue.statistics.common

import com.dingyue.statistics.BuildConfig
import com.dingyue.statistics.application.ApplicationWrapper
import com.dingyue.statistics.core.entity.ServerLog
import com.dingyue.statistics.exception.LogException
import com.dingyue.statistics.utils.AppUtil
import com.dingyue.statistics.utils.NetworkUtil
import com.dingyue.statistics.utils.SdkLog
import com.dingyue.statistics.uuid.DeviceUniqueIdProvider
import java.util.concurrent.ConcurrentHashMap

/**
 * Desc 公共参数维护类 (功能包含参数获取与部分参数更新,以及参数校验)
 * Author jiaxing_sun
 * Mail jiaxing_sun@dingyuegroup.cn
 * Date 2018/8/27 10:35
 */
object CommonParams {

    //业务方传递的用户id，一般指登录用户id|token
    var bizUserId: String? = null

    private var phoneIdentity: String? = null

    private var udid: String? = null
    /**
     * 初始化
     */
    fun init(udid: String?, appChannel: String? = null) {
        val context = ApplicationWrapper.getInstance().context
        this.udid = if (!udid.isNullOrBlank()) udid else ""

        this.phoneIdentity = AppUtil.getIMEI()

        val ecc = EnvCollectionConfig.newInstance()
        ecc.set(EnvCollectionConfig.ParamKey.CHANNEL_ID, if (appChannel.isNullOrBlank()) AppUtil.getAppChannel(context) else appChannel)
    }


    private fun collectionCommonParams(): ConcurrentHashMap<String, String?> {
        val params = ConcurrentHashMap<String, String?>()

        params.putAll(this.collectionImportantParams())

        val ecc = EnvCollectionConfig.newInstance()
        params["longitude"] = ecc.get(EnvCollectionConfig.ParamKey.LONGITUDE).orEmpty()
        params["latitude"] = ecc.get(EnvCollectionConfig.ParamKey.LATITUDE).orEmpty()
        params["city_info"] = ecc.get(EnvCollectionConfig.ParamKey.CITY_INFO).orEmpty()
        params["city_code"] = ecc.get(EnvCollectionConfig.ParamKey.CITY_CODE).orEmpty()
        params["location_detail"] = ecc.get(EnvCollectionConfig.ParamKey.LOCATION_DETAIL).orEmpty()
        //fixme 2个冗余参数
        params["citycode"] = ecc.get(EnvCollectionConfig.ParamKey.CITY_CODE).orEmpty()
        params["cityCode"] = ecc.get(EnvCollectionConfig.ParamKey.CITY_CODE).orEmpty()

        params["vendor"] = ecc.get(EnvCollectionConfig.ParamKey.VENDOR).orEmpty()
        params["operator"] = ecc.get(EnvCollectionConfig.ParamKey.PROVIDERS).orEmpty()
        params["operation"] = ecc.get(EnvCollectionConfig.ParamKey.PROVIDERS).orEmpty()
        params["resolution_ratio"] = ecc.get(EnvCollectionConfig.ParamKey.RESOLUTION_RATIO).orEmpty()
        params["resolution"] = ecc.get(EnvCollectionConfig.ParamKey.RESOLUTION_RATIO).orEmpty()
        params["model"] = ecc.get(EnvCollectionConfig.ParamKey.MODEL).orEmpty()
        params["sys_version"] = ecc.get(EnvCollectionConfig.ParamKey.SYSTEM_VERSION).orEmpty()
        params["storage"] = ecc.get(EnvCollectionConfig.ParamKey.STORAGE).orEmpty()
        params["storage_used"] = ecc.get(EnvCollectionConfig.ParamKey.STORAGE_USED).orEmpty()
        params["battery"] = ecc.get(EnvCollectionConfig.ParamKey.BATTERY).orEmpty()
        params["x86_arch"] = ecc.get(EnvCollectionConfig.ParamKey.X86_ARCH).orEmpty()
        params["mac_addr"] = ecc.get(EnvCollectionConfig.ParamKey.MAC_ADDRESS).orEmpty()
        params["wlan_name"] = ecc.get(EnvCollectionConfig.ParamKey.WLAN_NAME).orEmpty()
        params["website"] = ecc.get(EnvCollectionConfig.ParamKey.WEBSITE).orEmpty()
        params["ip"] = ecc.get(EnvCollectionConfig.ParamKey.IP).orEmpty()
        params["blue"] = ecc.get(EnvCollectionConfig.ParamKey.BLUE).orEmpty()
        params["cpu"] = ecc.get(EnvCollectionConfig.ParamKey.CPU).orEmpty()
        params["core_version"] = ecc.get(EnvCollectionConfig.ParamKey.CORE_VERSION).orEmpty()
        params["vpn"] = ecc.get(EnvCollectionConfig.ParamKey.VPN).orEmpty()
        params["wifi_mac"] = ecc.get(EnvCollectionConfig.ParamKey.WIFI_MAC).orEmpty()
        params["brand"] = ecc.get(EnvCollectionConfig.ParamKey.BRAND).orEmpty()

//        this.print(params)
        return params
    }

    /**
     * 只收集重要的统计事件需要的参数
     */
    private fun collectionImportantParams(): ConcurrentHashMap<String, String?> {
        val context = ApplicationWrapper.getInstance().context
        val ecc = EnvCollectionConfig.newInstance()

        val params = ConcurrentHashMap<String, String?>()
        if (!params.containsKey("uid") or params["uid"].isNullOrEmpty()) {
            params["uid"] = this.bizUserId.orEmpty()
        }

        if (!params.containsKey("uuid") or params["uuid"].isNullOrEmpty()) {
            params["udid"] = this.udid.orEmpty()
        }
        if (!params.containsKey("unique_id") or params["unique_id"].isNullOrEmpty()) {
            params["unique_id"] = DeviceUniqueIdProvider.diviceID
        }
        if (!params.containsKey("android_id") or params["android_id"].isNullOrEmpty()) {
            params["android_id"] = DeviceUniqueIdProvider.androidID
        }
        if (!params.containsKey("phone_identity") or params["phone_identity"].isNullOrEmpty()) {
            params["phone_identity"] = this.phoneIdentity.orEmpty()
        }
        if (!params.containsKey("meid") or params["meid"].isNullOrEmpty()) {
            params["meid"] = params["phone_identity"].orEmpty()
        }

        params["sdk_version"] = BuildConfig.VERSION_NAME
        params["sdk_version_code"] = BuildConfig.VERSION_CODE.toString()

        params["app_package"] = ecc.get(EnvCollectionConfig.ParamKey.PACKAGE_NAME).orEmpty()
        params["app_version"] = ecc.get(EnvCollectionConfig.ParamKey.VERSION_NAME).orEmpty()
        params["app_version_code"] = ecc.get(EnvCollectionConfig.ParamKey.VERSION_CODE).orEmpty()
        params["app_channel_id"] = ecc.get(EnvCollectionConfig.ParamKey.CHANNEL_ID).orEmpty()
        //fixme 4个冗余参数
        params["version_code"] = ecc.get(EnvCollectionConfig.ParamKey.VERSION_CODE).orEmpty()
        params["packageName"] = ecc.get(EnvCollectionConfig.ParamKey.PACKAGE_NAME).orEmpty()
        params["version"] = ecc.get(EnvCollectionConfig.ParamKey.VERSION_NAME).orEmpty()
        params["channelId"] = ecc.get(EnvCollectionConfig.ParamKey.CHANNEL_ID).orEmpty()

        params["os"] = "android"
        params["network"] = NetworkUtil.getNetworkType(context)
        return params
    }

    private fun print(params: ConcurrentHashMap<String, String?>) {
        SdkLog.e("==================>")
        params.forEach {
            SdkLog.d(it.key + " : "+it.value)
        }
        SdkLog.e("==================>")
    }

    fun appendCommonParams(log: ServerLog): ServerLog{
        this.collectionCommonParams().forEach {
            log.appendContent(it.key, it.value)
        }
        return log
    }

    fun appendCommonImportantParams(log: ServerLog): ServerLog {
        this.collectionImportantParams().forEach {
            log.appendContent(it.key, it.value)
        }
        return log
    }

    /**
     * 校验参数
     */
    fun paramsVerify(log: ServerLog) {
        if (log.content.isEmpty()) throw LogException("log empty ")

        // 验证必传参数
        if (!log.content.containsKey("udid")) {
            throw LogException("log lost param [udid] ")
        }
        if ((log.content["udid"] as String?).isNullOrBlank()) {
            throw LogException("param:[udid] can not be null or blank , current value is ${log.content["udid"]}")
        }
        if ((log.content["unique_id"] as String?).isNullOrBlank()) {
            throw LogException("param:[unique_id] can not be null or blank , current value is ${log.content["unique_id"]}")
        }
        // 检验app_channel_id
        if (!log.content.containsKey("app_channel_id")) {
            throw LogException("log lost param [app_channel_id] ")
        }
        if ((log.content["app_channel_id"] as String?).isNullOrBlank()) {
            throw LogException("param:[app_channel_id] can not be null or blank , current value is ${log.content["app_channel_id"]}")
        }
        if (log.content.containsKey("chapter_pages") && log.content["chapter_pages"].toString().toInt() > 100) {
            // 章节PV统计，页数大于100页，异常
            throw LogException("chapter_pages > 100 , please check param:[chapter_pages] ")
        }
        if (log.content.containsKey("start_time")
                && log.content.containsKey("end_time")
                && log.content.containsKey("chapter_pages")
                && (log.content["end_time"].toString().toLong() - log.content["start_time"].toString().toLong()) / log.content["chapter_pages"].toString().toInt() <= 1) {
            // 计算规则，(结束时间-开始时间) / 页数 = 每页阅读时长         时间参数单位：秒
            // 章节PV统计，每页平均阅读时间小于等于1s，视为异常统计
            throw LogException("read too fast , please check ")
        }
    }
}