package com.dingyue.statistics.common;

import android.content.Context;

import com.dingyue.statistics.application.ApplicationWrapper;
import com.dingyue.statistics.utils.SharedPreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

/**
 *
 */
public class Location {

    private static Location instance = null;
    private Location() {
        SharedPreferencesUtil sp = getSP();
        String json = sp.getString("location_info");
        LocationInfo li = getGson().fromJson(json, new TypeToken<LocationInfo>(){}.getType());
        this.configInner(li);
    }

    public static Location getInstance() {
        if (null == instance) {
            synchronized (Location.class) {
                if (null == instance) {
                    instance = new Location();
                }
            }
        }

        return instance;
    }

    public void config(LocationInfo locationInfo) {
        if (null == locationInfo) {
            return;
        }
        this.configInner(locationInfo);

        try {
            SharedPreferencesUtil sp = getSP();
            sp.putString("location_info", getGson().toJson(locationInfo));
        } catch (Exception e) {}
    }

    private SharedPreferencesUtil sp = null;
    private SharedPreferencesUtil getSP() {
        return null != sp ? sp : new SharedPreferencesUtil(ApplicationWrapper.getInstance().getContext().getSharedPreferences("sdk_log_location_v2", Context.MODE_PRIVATE));
    }

    private Gson gson = null;
    private Gson getGson() {
        return null != gson ? gson : new Gson();
    }

    private void configInner(LocationInfo locationInfo) {
        if (null == locationInfo) {
            return;
        }
        EnvCollectionConfig ecc = EnvCollectionConfig.newInstance();
        ecc.addPrams(EnvCollectionConfig.ParamKey.LONGITUDE, String.valueOf(locationInfo.longitude));
        ecc.addPrams(EnvCollectionConfig.ParamKey.LATITUDE, String.valueOf(locationInfo.latitude));
        ecc.addPrams(EnvCollectionConfig.ParamKey.CITY_CODE, String.valueOf(locationInfo.cityCode));
        ecc.addPrams(EnvCollectionConfig.ParamKey.CITY_INFO, locationInfo.cityInfo);
        ecc.addPrams(EnvCollectionConfig.ParamKey.CITY, locationInfo.city);
        ecc.addPrams(EnvCollectionConfig.ParamKey.LOCATION_DETAIL, locationInfo.locationDetail);
        ecc.addPrams(EnvCollectionConfig.ParamKey.AREA_CODE, locationInfo.areaCode);
        ecc.addPrams(EnvCollectionConfig.ParamKey.PROVINCE, locationInfo.province);
    }

    public static class LocationInfo{
        //经度信息
        public double longitude = 0;
        //纬度信息
        public double latitude = 0;
        //地区编号
        public String areaCode = "";
        //省份
        public String province = "";
        //市
        public String city = "";
        //城市信息
        public String cityInfo = "";
        //城市编号
        public String cityCode = "";
        //详细地址
        public String locationDetail = "";
    }
}
