package com.dingyue.statistics.common
/**
 * 针对project和logstore 指定一个对应的编码，用来存储使用
 */
enum class PLItemKey private constructor(val key: String, val project: String, val logstore: String, var desc: String?) {
    ZN_APP_EVENT("ZN_DF_APP_EVENT", "qdqx-bigdata", "event", "智能数据流APP点击事件"),
    ZN_APP_APPSTORE("ZN_APP_APPSTORE", "qdqx-bigdata", "appstore", "app列表"),
    ZN_APP_FEEDBACK("ZN_APP_FEEDBACK", "qdqx-bigdata", "feedback", "客户端问题章节反馈"),
    ZN_USER("ZN_USER", "qdqx-bigdata", "zn_user", "用户信息"),
    ZN_PV("ZN_PV", "qdqx-bigdata", "zn_pv", "阅读pv"),
    ZN_APP_CRASH("ZN_APP_CRASH", "qdqx-bigdata", "app_crash_new", "客户端异常日志"),
    ZN_AD("ZN_AD", "qdqx-bigdata", "ad_action", "广告日志");
//    APP_TIME_CHECK("APP_TIME_CHECK", "qdqx-bigdata", "app_time_check", "校验移动端时间");


    companion object {

        fun getKey(key: String): PLItemKey? {
            var itemKey: PLItemKey? = null
            for (item in PLItemKey.values()) {
                if (key.equals(item.key, ignoreCase = true)) {
                    itemKey = item
                    break
                }
            }
            return itemKey
        }
    }

}

