package com.dingyue.statistics.config

import com.dingyue.statistics.common.EnvCollectionConfig

/**
 * Desc AndroidLog存储配置
 * Author qiantao
 * Mail tao_qian@dingyuegroup.cn
 * Date 2017/11/10
 */
object AndroidLogConfig {
    const val CACHE_SIZE = 15
    const val CONSUME_TIMEOUT_SEC = 3 * 60
    const val DB_SIZE = CACHE_SIZE * 10

    var send_log_count = 30
        get() {
            val type: String? = EnvCollectionConfig.newInstance().get(EnvCollectionConfig.ParamKey.NETWORK_TYPE)
            return if ("wifi" == type) { 100 } else { 30 }
        }
}