package com.dingyue.statistics.core

import java.util.*

/**
 * Created by yuchao on 2018/11/12 0012.
 * Mail yuchao_liu@dingyuegroup.cn
 * Desc 异常日志统计帮助类
 *
 * Event事件记录器
 */
object EventLogRecorder {

    private const val EVENT_LENGTH = 10

    private val latestEvents by lazy {
        LinkedList<String>()
    }

    fun updateEvent(pageCode: String, identify: String) {
        synchronized(latestEvents) {
            if (EVENT_LENGTH <= latestEvents.size) {
                latestEvents.removeAt(0)
            }
            latestEvents.add("$pageCode:$identify")
        }
    }

    fun getEvents(): String {
        val sb = StringBuffer()
        synchronized(latestEvents) {
            if (latestEvents.isNotEmpty()) {
                val size = latestEvents.size
                for (i in latestEvents.indices) {
                    sb.append(latestEvents[i])
                    if (i != size - 1) sb.append("->")
                }
            }
        }
        return sb.toString()
    }

}