package com.dingyue.statistics.core

import com.dingyue.statistics.db.repository.SdkRepositoryFactory

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/13 17:25
 * @email hn_yangxiaowei@163.com
 * @desc 日志清除
 */
object LogClear {

    fun tryClear() {
        //清除过期七天的数据
        val minTimMillis = System.currentTimeMillis() - (7 * 24 * 60 * 60 * 1000)
        try {
            val factory = SdkRepositoryFactory.loadSdkRepository()
            factory.logRepository.deleteOutOfDate(minTimMillis)
            factory.chapterRepository.deleteOutOfDate(minTimMillis)

            factory.logRepository.deleteGarbage()
        } catch (e: java.lang.Exception) {
            //todo 这里是为了暂时处理数据库报错
            e.printStackTrace()
        }
    }
}