package com.dingyue.statistics.core.entity

import com.dingyue.statistics.common.PLItemKey
import com.dingyue.statistics.core.StatRealService
import com.dingyue.statistics.db.dao.bean.LogType
import com.dingyue.statistics.time.TimeManager
import com.dingyue.statistics.utils.JsonUtil
import org.jetbrains.annotations.NotNull
import org.json.JSONException
import java.util.*

/**
 * Created by wangjwchn on 16/8/2
 */
class ServerLog {

    var content: HashMap<String, Any?>

    @LogType
    var eventType = LogType.MAJORITY

    var id = 0

    var serviceBack: (() -> Unit)? = null

    /**
     * 构建ServerLog
     *
     * @param type
     */
    constructor(type: PLItemKey) {
        content = if (StatRealService.config.enableSaveLog) {
            // 调试时，采用有序map，顺序输出便于人工查看
            LinkedHashMap()
        } else {
            // 实际使用时，采用无序map，节省资源
            HashMap()
        }
        if (!content.containsKey("project")) {
            content["project"] = type.project
        }
        if (!content.containsKey("logstore")) {
            content["logstore"] = type.logstore
        }
        if (type == PLItemKey.ZN_APP_APPSTORE || type == PLItemKey.ZN_USER || type == PLItemKey.ZN_PV) {
            eventType = LogType.MINORITY // minority直接上传，majority根据时间和数量，按条件上传
        }
        content["__time__"] = TimeManager.serviceTimeMillis() / 1000
    }

    constructor(_id: Int, type: String, contentJson: String) {
        this.id = _id
        this.eventType = type
        try {
            this.content = JsonUtil.fromJson(contentJson)
        } catch (e: JSONException) {
            e.printStackTrace()
            this.content = HashMap()
        }
    }

    fun appendContent(@NotNull key: String, value: String?) {
        if (key.isEmpty()) {
            return
        }
        // 处理空参数 （将null或"" 均改为 大写NULL字符串  "NULL"）
        if (value.isNullOrBlank() || value == "null") {
            content[key] = "NULL"
        } else {
            content[key] = value.orEmpty()
        }
    }
}
