package com.dingyue.statistics.db.dao

import android.arch.persistence.room.Dao
import android.arch.persistence.room.Query
import com.dingyue.statistics.db.dao.bean.BaseChapterFeedback

/**
 * Desc 章节反馈dao
 * Author jiaxing_sun
 * Mail jiaxing_sun@dingyuegroup.cn
 * Date 2018/11/7 11:55
 */
@Dao
interface ChapterFeedbackDao : BaseDao<BaseChapterFeedback> {

    @Query("SELECT COUNT(*) FROM chapter_feedback WHERE book_name = :bookName AND chapter_id = :chapterId AND type = :type")
    fun getSameFeedbackCount(bookName: String, chapterId: String, type: Int): Int

    @Query("DELETE FROM chapter_feedback WHERE create_time <= :time")
    fun deleteOutOfDate(time: Long)
}