package com.dingyue.statistics.db.dao

import android.arch.persistence.room.Dao
import android.arch.persistence.room.Query
import com.dingyue.statistics.db.dao.bean.LocalLog

/**
 * Desc 打点日志 Dao
 * Author qiantao
 * Mail tao_qian@dingyuegroup.cn
 * Date 2018/3/19 0019 14:59
 */
@Dao
interface LocalLogDao : BaseDao<LocalLog> {

    @Query("SELECT * FROM LocalLog LIMIT :count")
    fun queryAll(count: Int): List<LocalLog>

    @Query("SELECT * FROM LocalLog WHERE status = 0")
    fun queryIdleAll(): List<LocalLog>

    @Query("SELECT * FROM LocalLog WHERE status = 0 AND id > :start ORDER BY id ASC LIMIT :count")
    fun queryIdleAllByLimit(start: Int, count: Int): List<LocalLog>

    @Query("SELECT * FROM LocalLog WHERE status = 0 AND type = :type LIMIT :count")
    fun queryIdle(type: String, count: Int): List<LocalLog>

    @Query("DELETE FROM LocalLog WHERE id = :id")
    fun deleteById(id: Int)

    @Query("DELETE FROM LocalLog WHERE id in (:ids)")
    fun deleteByIds(ids: List<Int>)

    @Query("DELETE FROM LocalLog WHERE time <= :time")
    fun deleteOutOfDate(time: Long)

    @Query("DELETE FROM LocalLog WHERE contentJson = null")
    fun deleteGarbage()

    @Query("SELECT * FROM LocalLog WHERE type = :type ORDER BY time ASC LIMIT :count")
    fun queryByTime(type: String, count: Int): List<LocalLog>

    @Query("SELECT COUNT(*) FROM LocalLog")
    fun getNumberOfRows(): Int

    @Query("UPDATE LocalLog SET status = 0 WHERE id in (:ids)")
    fun resetToIdle(ids: List<Int>)

    @Query("UPDATE LocalLog SET status = 0 WHERE status != 0")
    fun resetToIdle()

    @Query("UPDATE LocalLog SET status = 1 WHERE id in (:ids)")
    fun resetToWaiting(ids: List<Int>)
}