package com.dingyue.statistics.db.dao.bean

import android.arch.persistence.room.ColumnInfo
import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import java.util.HashMap

/**
 * Desc 章节错误信息反馈
 * Author jiaxing_sun
 * Mail jiaxing_sun@dingyuegroup.cn
 * Date 2018/11/7 10:32
 */
@Entity(tableName = "chapter_feedback")
open class BaseChapterFeedback {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    var id: Int = 0

    @ColumnInfo(name = "book_source_id")
    var bookSourceId: String? = null

    @ColumnInfo(name = "book_name")
    var bookName: String? = null

    @ColumnInfo(name = "author")
    var author: String? = null

    @ColumnInfo(name = "book_chapter_id")
    var bookChapterId: String? = null

    @ColumnInfo(name = "chapter_id")
    var chapterId: String? = null

    @ColumnInfo(name = "chapter_name")
    var chapterName: String? = null

    @ColumnInfo(name = "channel_code")
    var channelCode: String? = null

    @ColumnInfo(name = "serial")
    var serial: Int = 0

    //章节host
    @ColumnInfo(name = "host")
    var host: String? = null

    //错误类型，1-书籍无法阅读，2-缓存失败， 3-网络无法连接，4-空章乱码，5-重复内容或章节错误
    @ColumnInfo(name = "type")
    var type: Int = 0

    @ColumnInfo(name = "create_time")
    var createTime = System.currentTimeMillis()


    override fun toString(): String {
        return "BaseChapterFeedback{" +
                "bookSourceId='" + bookSourceId + '\'' +
                ", bookName='" + bookName + '\'' +
                ", author='" + author + '\'' +
                ", bookChapterId='" + bookChapterId + '\'' +
                ", chapterId='" + chapterId + '\'' +
                ", chapterName='" + chapterName + '\'' +
                ", channelCode='" + channelCode + '\'' +
                ", serial=" + serial +
                ", host='" + host + '\'' +
                ", type=" + type +
                '}'
    }

    open fun toMap(): Map<String, String> {
        val res = HashMap<String, String>()
        res["bookSourceId"] = bookSourceId.orEmpty()
        res["bookName"] = bookName.orEmpty()
        res["author"] = author.orEmpty()
        res["bookChapterId"] = bookChapterId.orEmpty()
        res["chapterId"] = chapterId.orEmpty()
        res["chapterName"] = chapterName.orEmpty()
        res["channelCode"] = channelCode.orEmpty()
        res["serial"] = serial.toString()
        res["host"] = host.orEmpty()
        res["type"] = type.toString()
        return res
    }

}