package com.dingyue.statistics.db.dao.bean

import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import com.dingyue.statistics.utils.JsonUtil

/**
 * Desc 打点日志
 * Author qiantao
 * Mail tao_qian@dingyuegroup.cn
 * Date 2018/3/19 0019 14:45
 */
@Entity(tableName = "LocalLog")
class LocalLog() {

    @PrimaryKey(autoGenerate = true)
    var id: Int = 0

    @LogType
    var type: String = LogType.MAJORITY

    var time: String = System.currentTimeMillis().toString()

    var contentJson: String? = null

    //状态 0: 闲置中  1: 执行中
    var status: Int = 0

    constructor(@LogType type: String, content: Map<String, Any?>) : this() {
        this.type = type
        this.contentJson = JsonUtil.fromMap(content)
    }

    constructor(id: Int, @LogType type: String, content: Map<String, Any?>) : this(type, content){
        this.id = id
    }
}