package com.dingyue.statistics.db.dao.bean;

import android.support.annotation.StringDef;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/13 16:11
 * @email hn_yangxiaowei@163.com
 * @desc
 *  两类log类型
 *  minority直接上传，majority根据时间和数量，按条件上传
 */
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.SOURCE)
@StringDef({
        LogType.MAJORITY,
        LogType.MINORITY
})
public @interface LogType {
    //非实时上传
    String MAJORITY = "majority";

    //实时上传类型
    String MINORITY = "minority";
    //立刻上传类型
    String IMMEDIATELY = "immediately";
}
