package com.dingyue.statistics.db.dao.database

import android.arch.persistence.db.SupportSQLiteDatabase
import android.arch.persistence.room.Database
import android.arch.persistence.room.Room
import android.arch.persistence.room.RoomDatabase
import android.arch.persistence.room.migration.Migration
import android.content.Context
import com.dingyue.statistics.db.dao.ChapterFeedbackDao
import com.dingyue.statistics.db.dao.LocalLogDao
import com.dingyue.statistics.db.dao.bean.BaseChapterFeedback
import com.dingyue.statistics.db.dao.bean.LocalLog

/**
 * Desc 打点日志 database
 * Author qiantao
 * Mail tao_qian@dingyuegroup.cn
 * Date 2018/3/19 0019 15:07
 *
 * 不直接调用， 通过RepositoryFactory进行操作【里面包含了处理插入|更新|删除时的多线程并发处理】
 */
@Database(entities = [LocalLog::class, BaseChapterFeedback::class], version = 3)
abstract class LocalLogDataBase : RoomDatabase() {

    abstract fun logDao(): LocalLogDao
    abstract fun chapterFeedbackDao(): ChapterFeedbackDao

    companion object {

        @Volatile
        private var dataBase: LocalLogDataBase? = null

        @JvmStatic
        fun getInstance(context: Context): LocalLogDataBase {
            if (dataBase?.isOpen != true) {
                synchronized(LocalLogDataBase::class.java) {
                    if (dataBase?.isOpen != true) {
                        dataBase = Room.databaseBuilder(context, LocalLogDataBase::class.java, "log.db")
                                .allowMainThreadQueries()
                                .addMigrations(migration1_2)
                                .addMigrations(migration2_3)
                                .build()
                    }
                }
            }
            return dataBase!!
        }

        private val migration1_2 = object : Migration(1, 2) {
            override fun migrate(database: SupportSQLiteDatabase) {
                database.execSQL("CREATE TABLE IF NOT EXISTS `chapter_feedback` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `book_source_id` TEXT , `book_name` TEXT , `author` TEXT, `book_chapter_id` TEXT, `chapter_id` TEXT, `chapter_name` TEXT, `channel_code` TEXT, `serial` INTEGER NOT NULL, `host` TEXT, `type` INTEGER NOT NULL, `create_time` INTEGER NOT NULL)")
            }
        }

        private val migration2_3 = object : Migration(2, 3) {
            override fun migrate(database: SupportSQLiteDatabase) {
                database.execSQL("ALTER TABLE LocalLog  ADD COLUMN status INTEGER NOT NULL default 0")
            }
        }
    }

}