package com.dingyue.statistics.db.repository

import android.annotation.SuppressLint
import android.content.Context
import com.dingyue.statistics.db.dao.ChapterFeedbackDao
import com.dingyue.statistics.db.dao.bean.BaseChapterFeedback
import com.dingyue.statistics.db.dao.database.LocalLogDataBase

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/19 15:09
 * @email hn_yangxiaowei@163.com
 * @desc
 */
class ChapterRepository private constructor(private var dao: ChapterFeedbackDao): IChapterRepository {

    companion object {
        @Volatile
        @SuppressLint("StaticFieldLeak")
        private var repository: ChapterRepository? = null
        private var dataBase: LocalLogDataBase? = null

        fun loadChapterRepository(context: Context): ChapterRepository {
            if (null == repository || dataBase?.isOpen != true) {
                try {
                    synchronized(SdkRepositoryFactory::class.java) {
                        if (null == repository || dataBase?.isOpen != true) {
                            dataBase = LocalLogDataBase.getInstance(context)
                            repository = ChapterRepository(dataBase!!.chapterFeedbackDao())
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            return repository!!
        }
    }

    override fun getSameFeedbackCount(bookName: String, chapterId: String, type: Int): Int {
        return dao.getSameFeedbackCount(bookName, chapterId, type)
    }

    @Synchronized
    override fun deleteOutOfDate(time: Long) {
        dao.deleteOutOfDate(time)
    }

    @Synchronized
    override fun insert(t: BaseChapterFeedback) {
        dao.insert(t)
    }

    @Synchronized
    override fun insertOrUpdate(t: BaseChapterFeedback) {
        dao.insertOrUpdate(t)
    }

    @Synchronized
    override fun insertOrUpdate(tList: List<BaseChapterFeedback>) {
        dao.insertOrUpdate(tList)
    }

    @Synchronized
    override fun insert(tList: List<BaseChapterFeedback>) {
        dao.insert(tList)
    }

    @Synchronized
    override fun delete(t: BaseChapterFeedback) {
        dao.delete(t)
    }

    @Synchronized
    override fun delete(vararg t: BaseChapterFeedback) {
//        dao.delete(t)
    }

    @Synchronized
    override fun delete(tList: List<BaseChapterFeedback>) {
        dao.delete(tList)
    }

    @Synchronized
    override fun update(t: BaseChapterFeedback) {
        dao.update(t)
    }

    @Synchronized
    override fun update(tList: List<BaseChapterFeedback>) {
        dao.update(tList)
    }

    override fun release() {
        try {
            if (dataBase?.isOpen == true) {
                dataBase?.close()
            }
        } catch (e: java.lang.Exception) {}
    }
}