package com.dingyue.statistics.db.repository

import android.annotation.SuppressLint
import android.content.Context
import com.dingyue.statistics.db.dao.LocalLogDao
import com.dingyue.statistics.db.dao.bean.LocalLog
import com.dingyue.statistics.db.dao.database.LocalLogDataBase

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/19 15:00
 * @email hn_yangxiaowei@163.com
 * @desc
 */
class LogRepository private constructor(private var dao: LocalLogDao): ILogRepository {

    companion object {
        @Volatile
        @SuppressLint("StaticFieldLeak")
        private var repository: LogRepository? = null
        private var dataBase: LocalLogDataBase? = null

        fun loadLogRepository(context: Context): LogRepository {
            if (null == repository || dataBase?.isOpen != true) {
                try {
                    synchronized(SdkRepositoryFactory::class.java) {
                        if (null == repository || dataBase?.isOpen != true) {
                            dataBase = LocalLogDataBase.getInstance(context)
                            repository = LogRepository(dataBase!!.logDao())
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            return repository!!
        }
    }

    override fun queryAll(count: Int): List<LocalLog> {
        return dao.queryAll(count)
    }

    override fun queryIdleAll(): List<LocalLog> {
        return dao.queryIdleAll()
    }

    override fun queryIdleAllByLimit(start: Int, count: Int): List<LocalLog> {
        return dao.queryIdleAllByLimit(start, count)
    }

    override fun queryIdle(type: String, count: Int): List<LocalLog> {
        return dao.queryIdle(type, count)
    }

    @Synchronized
    override fun deleteById(id: Int) {
        dao.deleteById(id)
    }

    @Synchronized
    override fun deleteByIds(ids: List<Int>) {
        dao.deleteByIds(ids)
    }

    @Synchronized
    override fun deleteOutOfDate(time: Long) {
        dao.deleteOutOfDate(time)
    }

    @Synchronized
    override fun deleteGarbage() {
        dao.deleteGarbage()
    }

    override fun queryByTime(type: String, count: Int): List<LocalLog> {
        return dao.queryByTime(type, count)
    }

    override fun getNumberOfRows(): Int {
        return dao.getNumberOfRows()
    }

    @Synchronized
    override fun resetToIdle(ids: List<Int>) {
        dao.resetToIdle(ids)
    }

    @Synchronized
    override fun resetToIdle() {
        dao.resetToIdle()
    }

    @Synchronized
    override fun resetToWaiting(ids: List<Int>) {
        dao.resetToWaiting(ids)
    }

    @Synchronized
    override fun insert(t: LocalLog) {
        dao.insert(t)
    }

    @Synchronized
    override fun insertOrUpdate(t: LocalLog) {
        dao.insertOrUpdate(t)
    }

    @Synchronized
    override fun insertOrUpdate(tList: List<LocalLog>) {
        dao.insertOrUpdate(tList)
    }

    @Synchronized
    override fun insert(tList: List<LocalLog>) {
        dao.insert(tList)
    }

    @Synchronized
    override fun delete(t: LocalLog) {
        dao.delete(t)
    }

    @Synchronized
    override fun delete(vararg t: LocalLog) {
//        dao.delete(t)
    }

    @Synchronized
    override fun delete(tList: List<LocalLog>) {
        dao.delete(tList)
    }

    @Synchronized
    override fun update(t: LocalLog) {
        dao.update(t)
    }

    @Synchronized
    override fun update(tList: List<LocalLog>) {
        dao.update(tList)
    }

    override fun release() {
        try {
            if (dataBase?.isOpen == true) {
                dataBase?.close()
            }
        } catch (e: java.lang.Exception) {}
    }
}