package com.dingyue.statistics.db.repository

import android.annotation.SuppressLint
import android.content.Context
import com.dingyue.statistics.application.ApplicationWrapper

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/19 14:43
 * @email hn_yangxiaowei@163.com
 * @desc
 */
class SdkRepositoryFactory private constructor(context: Context) : IRepository{

    val logRepository = LogRepository.loadLogRepository(context)

    val chapterRepository = ChapterRepository.loadChapterRepository(context)

    companion object {
        @Volatile
        @SuppressLint("StaticFieldLeak")
        private var sdkRepository: SdkRepositoryFactory? = null

        fun loadSdkRepository(): SdkRepositoryFactory {
            if (null == sdkRepository) {
                try {
                    synchronized(SdkRepositoryFactory::class.java) {
                        if (null == sdkRepository) {
                            sdkRepository = SdkRepositoryFactory(ApplicationWrapper.getInstance().context)
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            return sdkRepository!!
        }
    }

    @Synchronized
    override fun release() {
        logRepository.release()
        chapterRepository.release()
        sdkRepository = null
    }

}