package com.dingyue.statistics.fix

import com.dingyue.statistics.client.Ids
import com.dingyue.statistics.core.entity.ServerLog
import com.dingyue.statistics.utils.DataFieldTransfer

/**
 * @author 170303 - yangxiaowei
 * @date 2019/8/15 15:14
 * @email hn_yangxiaowei@163.com
 * @desc 针对page_code为SYSTEM情况修复，历史原因：数据存在不完整性
 */
object PageCodeOnSystemFix {

    /**
     * 上报字段：如能获取到则记录，获取不到标记空，
     * 必传字段为IMEI、手机型号、系统版本号、屏幕分辨率、运营商、网络类型；
     * 初期只上报page_code='SYSTEM'的点位，其他点位不传。
     */
    fun tryFixSystemEvent(log: ServerLog) {
        val map = log.content

        if (map["page_code"] == Ids.ID_SYSTEM) {
            // 以下参数转换后放到 data字段中
            val extraData = HashMap<String, String>()
            extraData["phone_identity"] = map["phone_identity"]?.toString().orEmpty()
            extraData["model"] = map["model"]?.toString().orEmpty()
            extraData["sys_version"] = map["sys_version"]?.toString().orEmpty()
            extraData["resolution"] = map["resolution"]?.toString().orEmpty()
            extraData["mac_addr"] = map["mac_addr"]?.toString().orEmpty()
            extraData["wlan_name"] = map["wlan_name"]?.toString().orEmpty()
            extraData["operation"] = map["operation"]?.toString().orEmpty()
            extraData["website"] = map["website"]?.toString().orEmpty()
            extraData["ip"] = map["ip"]?.toString().orEmpty()
            extraData["blue"] = map["blue"]?.toString().orEmpty()
            extraData["citycode"] = map["citycode"]?.toString().orEmpty()
            extraData["storage"] = map["storage"]?.toString().orEmpty()
            extraData["storage_used"] = map["storage_used"]?.toString().orEmpty()
            extraData["cpu"] = map["cpu"]?.toString().orEmpty()
            extraData["core_version"] = map["core_version"]?.toString().orEmpty()
            extraData["battery"] = map["battery"]?.toString().orEmpty()
            extraData["x86_arch"] = map["x86_arch"]?.toString().orEmpty()
            extraData["vpn"] = map["vpn"]?.toString().orEmpty()
            extraData["meid"] = map["meid"]?.toString().orEmpty()
            extraData["wifi_mac"] = map["wifi_mac"]?.toString().orEmpty()
            // 转换
            val dataString = DataFieldTransfer.transfer(extraData)
            // 判断是否追加
            if (map.containsKey("data")) {
                map["data"] = map["data"].toString().plus("`").plus(dataString)
            } else {
                map["data"] = dataString
            }
        }
    }
}