package com.dingyue.statistics.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.dingyue.statistics.common.EnvCollectionConfig
import com.dingyue.statistics.utils.DeviceInfo

/**
 * Desc 网络状态改变监听
 * Author jiaxing_sun
 * Mail jiaxing_sun@dingyuegroup.cn
 * Date 2018/8/28 14:44
 */
class NetworkChangeReceiver : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE" == intent.action) {
            EnvCollectionConfig.newInstance().set(EnvCollectionConfig.ParamKey.NETWORK_TYPE, DeviceInfo.getNetState(context))
        }
    }

    companion object {
        private val singleton: NetworkChangeReceiver by lazy(LazyThreadSafetyMode.SYNCHRONIZED) {
            NetworkChangeReceiver()
        }

        fun build(): NetworkChangeReceiver {
            return singleton
        }
    }

}