package com.dingyue.statistics.time

import android.os.SystemClock

/**
 * Created by yuchao on 2018/11/5 0005.
 * Mail yuchao_liu@dingyuegroup.cn
 * Desc 时钟校准
 */
class TimeManager private constructor() {

    companion object {
        val instance by lazy(LazyThreadSafetyMode.SYNCHRONIZED) {
            TimeManager()
        }

        fun serviceTimeMillis(): Long {
            return instance.serviceTimeMillis()
        }

        fun canUseServiceTime(): Boolean {
            return instance.isServerTime
        }
    }

    // 时间差值 = 以前服务器时间 - 以前服务器时间的获取时刻的系统启动时间
    private var differenceTime: Long = 0
    // 是否是服务器时间, 是,使用计算后的服务器时间; 否,使用本地时间
    private var isServerTime: Boolean = false


    @Synchronized
    fun serviceTimeMillis(): Long {
        if (!isServerTime) {
//            SdkLog.e("TimeManager: 使用本地时间 ---------------- ${AppUtil.log_formatter.format(System.currentTimeMillis())}")
            return System.currentTimeMillis()
        }
//        SdkLog.e("TimeManager: 使用服务器时间 -- ${AppUtil.log_formatter.format(differenceTime + SystemClock.elapsedRealtime())}")
        //时间差加上当前手机启动时间就是准确的服务器时间了
        return differenceTime + SystemClock.elapsedRealtime()
    }

    @Synchronized
    fun initServerTime(serviceTime: Long) {
//        SdkLog.e("TimeManager: 获取服务器时间 ------------------------------- ${AppUtil.log_formatter.format(serviceTime)}")
        //记录时间差
        differenceTime = serviceTime - SystemClock.elapsedRealtime()
        isServerTime = true
    }
}