package com.dingyue.statistics.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import java.lang.reflect.Field;

public class AppInfo {

    public String applicationId;
    public String versionName;
    public int versionCode;
    public long installTime;
    public long lastUpdateTime;

    private static AppInfo instance = null;
    private AppInfo() {}
    public static AppInfo getInstance() {
        if (null == instance) {
            synchronized (AppInfo.class) {
                if (null == instance) {
                    instance = new AppInfo();
                }
            }
        }

        return instance;
    }

    private Class<?> clazz;
    public AppInfo init(String buildConfigClassPath) {
        if (TextUtils.isEmpty(buildConfigClassPath)) {
            return this;
        }
        try {
            Class<?> buildConfig = Class.forName(buildConfigClassPath);
            clazz = buildConfig;

            applicationId = getStringField("APPLICATION_ID", buildConfig);
            versionName = getStringField("VERSION_NAME", buildConfig);
            versionCode = getIntField("VERSION_CODE", buildConfig);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return this;
    }

    public AppInfo init(Context context) {

        try {
            PackageManager pm = context.getApplicationContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            this.applicationId = context.getApplicationInfo().packageName;
            this.versionName = pi.versionName;
            this.versionCode = pi.versionCode;
            this.installTime = pi.firstInstallTime;
            this.lastUpdateTime = pi.lastUpdateTime;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Object getStringFiled(String fieldName) {
        Object o = null;
        try {

            o = this.getStringField(fieldName, this.clazz);
        }catch (Exception e) {
            e.printStackTrace();
        }

        return o == null ? new Object() : o;
    }

    private String getStringField(String fieldName, Object obj)
            throws NoSuchFieldException, IllegalAccessException {
        Class clazz;
        if (obj instanceof Class) {
            clazz = (Class) obj;
        } else {
            clazz = obj.getClass();
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (String) field.get(obj);
    }

    private int getIntField(String fieldName, Object obj)
            throws NoSuchFieldException, IllegalAccessException {
        Class clazz;
        if (obj instanceof Class) {
            clazz = (Class) obj;
        } else {
            clazz = obj.getClass();
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.getInt(obj);
    }
}
