package com.dingyue.statistics.utils

import android.app.usage.UsageStats
import android.app.usage.UsageStatsManager
import android.content.Context
import android.content.pm.ApplicationInfo
import android.content.pm.PackageManager
import android.net.wifi.WifiManager
import com.dingyue.statistics.uuid.DeviceUniqueIdProvider
import org.json.JSONArray
import org.json.JSONObject
import java.util.*


object AppUtil {

    /**
     * 获取IMEI（设备串号）
     */
    fun getIMEI(): String {

        val deviceId = DeviceUniqueIdProvider.getImei()

        SdkLog.e("DeviceUniqueIdProvider: 使用本地缓存 TELEPHONY_SERVICE -- $deviceId")

        return deviceId
    }

    /**
     * 获取MAC地址
     */
    fun getMacAddress(context: Context): String {
        try {
            val wm = context.getSystemService(Context.WIFI_SERVICE) as WifiManager?
            return if (wm != null) wm.connectionInfo.macAddress else ""
        } catch (exception: Exception) {
            exception.printStackTrace()
        }

        return ""
    }

    //获取用户手机安装的所有app列表
    fun scanLocalInstallAppList(packageManager: PackageManager): String {
        val sb = StringBuilder()
        try {
            val packageInfos = packageManager.getInstalledPackages(0)
            for (i in packageInfos.indices) {
                val packageInfo = packageInfos[i]
                //过滤掉系统app
                if (ApplicationInfo.FLAG_SYSTEM and packageInfo.applicationInfo.flags <= 0) {
                    if (i == packageInfos.size) {
                        sb.append(packageInfo.applicationInfo.loadLabel(packageManager))
                    } else {
                        sb.append(packageInfo.applicationInfo.loadLabel(packageManager)).append("`")
                    }
                }
            }
        } catch (exception: Exception) {
            exception.printStackTrace()
        }

        return sb.toString()
    }

    /**
     * 获取渠道
     */
    fun getAppChannel(context: Context?): String {
        if (context == null) return ""
        try {
            return context.packageManager
                    .getApplicationInfo(context.packageName, PackageManager.GET_META_DATA)
                    ?.metaData
                    ?.getString("DY_APP_CHANNEL", "") ?: "";
        } catch (exception: PackageManager.NameNotFoundException) {
            exception.printStackTrace()
        }

        return ""
    }

    /**
     * 判断时间是否是同一天
     */
    fun isSameDay(firstTime: Long, secondTime: Long): Boolean {
        val pre = Calendar.getInstance()
        val predate = Date(secondTime)
        pre.time = predate

        val cal = Calendar.getInstance()
        val date = Date(firstTime)
        cal.time = date

        if (cal.get(Calendar.YEAR) == pre.get(Calendar.YEAR)) {
            val sameDay = cal.get(Calendar.DAY_OF_YEAR) - pre.get(Calendar.DAY_OF_YEAR)
            if (sameDay == 0) {
                return true
            }
        }

        return false
    }

    fun loadUserApplicationList(context: Context): String {
        try {
            val packageManager = context.packageManager
            val packages = packageManager.getInstalledPackages(0)
            if (packages.size > 0) {
                val appInfoList = JSONArray()
                var appInfo: JSONObject

                var usageStatsList: List<UsageStats>? = null

                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP_MR1) {
                    val usageStatsManager = context.getSystemService(
                            Context.USAGE_STATS_SERVICE) as UsageStatsManager?

                    val calendar = Calendar.getInstance()
                    val endTime = calendar.timeInMillis

                    calendar.add(Calendar.DAY_OF_MONTH, -12)
                    val startTime = calendar.timeInMillis

                    if (usageStatsManager != null) {
                        usageStatsList = usageStatsManager.queryUsageStats(
                                UsageStatsManager.INTERVAL_MONTHLY, startTime, endTime)
                    }

                    for (packageInfo in packages) {
                        if (ApplicationInfo.FLAG_SYSTEM and packageInfo.applicationInfo.flags <= 0) {
                            appInfo = JSONObject()

                            packageInfo.applicationInfo.loadLabel(packageManager)

                            val packageName = packageInfo.packageName

                            //应用名称
                            appInfo.put("app_name", packageInfo.applicationInfo.loadLabel(packageManager).toString().replace(":", "").replace("`", ""))
                            //应用包名
                            appInfo.put("app_package_name", packageName.replace(":", "").replace("`", ""))
                            //应用安装时间
                            appInfo.put("app_install_time", packageInfo.firstInstallTime)
                            //应用最近一次更新时间
                            appInfo.put("app_last_update_time", packageInfo.lastUpdateTime)

                            if (usageStatsList != null && usageStatsList.isNotEmpty()) {
                                for (usageStats in usageStatsList) {
                                    val usagePackageName = usageStats.packageName

                                    if (usagePackageName == packageName) {
                                        //应用近1月总运行时长
                                        appInfo.put("app_last_month_run_time", usageStats.totalTimeInForeground)
                                        appInfo.put("app_last_month_used_time", usageStats.lastTimeUsed)
                                    }

                                    try {
                                        val field = usageStats.javaClass.getDeclaredField("mLaunchCount")
                                        if (field != null) {
                                            //应用近1月启动次数
                                            appInfo.put("app_last_month_start_num", field.getInt(usageStats))
                                        }
                                    } catch (exception: Exception) {
                                        exception.printStackTrace()
                                    }

                                }
                            }
                            appInfoList.put(appInfo)
                        }
                    }
                }

                return "app_infos:$appInfoList"
            }
        } catch (exception: Exception) {
            exception.printStackTrace()
        }

        return ""
    }
}
