package com.dingyue.statistics.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @author LingJiNian
 * @date 2018/10/5 16:36
 * @email hn_yangxiaowei@163.com
 * @desc
 */
public class DateUtil {
    private DateUtil() {}

    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public static long transform(String date) {
        if (null == date || date.isEmpty()) {
            return 0L;
        }
        try {
            return getDateFormat().parse(date).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return 0L;
    }

    public static String format(long time) {
        return getDateFormat().format(time);
    }

    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<>();

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = null;
        df = threadLocal.get();
        if(df == null){
            df = sdf;
            threadLocal.set(df);
        }

        return df;
    }
}
