package com.dingyue.statistics.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.view.Display;
import android.view.WindowManager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;

import static android.content.Context.ACTIVITY_SERVICE;
import static android.content.Context.TELEPHONY_SERVICE;

/**
 * @author Ling Ji Nian
 * @date 2018/7/17 11:01
 * @email hn_yangxiaowei@163.com
 * @desc
 */
public class DeviceInfo {
    /**
     * 系统版本号
     */
    public static String getRelease() {
        return Build.VERSION.RELEASE;
    }

    /**
     * 获取内核版本
     */
    public static String getSystemInnerVersion() {
        String ver;
        if (Build.DISPLAY.contains(Build.VERSION.INCREMENTAL)) {
            ver = Build.DISPLAY;
        } else {
            ver = Build.VERSION.INCREMENTAL;
        }
        return ver;
    }

    /**
     * 设备厂商
     */
    public static String getPhoneBrand() {
        return Build.BOARD + "" + Build.MANUFACTURER;
    }

    /**
     * 设备名称
     */
    public static String getPhoneModel() {
        return Build.MODEL;
    }

    /**
     * X86架构
     */
    public static String getX86() {
        return Build.CPU_ABI;
    }

    /**
     * 获取手机号码
     */
    public static String getPhoneNumber(Context context) {
        TelephonyManager tm = (TelephonyManager) context.getSystemService(TELEPHONY_SERVICE);
        String phone = "";
        if (tm != null) {
            phone = tm.getLine1Number();
        }
        if (phone != null && phone.length() > 0) {
            phone = phone.replace("#", "");
            phone = phone.replace("*", "");
        }
        return phone;
    }

    /**
     * 获取IMEI（设备串号）
     */
    public static String getIMEI(Context context) {
        String deviceId = "";
        try {
            TelephonyManager cm = (TelephonyManager) context.getSystemService(TELEPHONY_SERVICE);
            deviceId = cm.getDeviceId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return deviceId;
    }

    /**
     * 判读是否启动VPN
     */
    public static boolean getIsVPNUsed() {
        try {
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            if (niList != null) {
                for (NetworkInterface networkInterface : Collections.list(niList)) {
                    if (!networkInterface.isUp()
                            || networkInterface.getInterfaceAddresses().size() == 0) {
                        continue;
                    }
                    if ("tun0".equals(networkInterface.getName()) || "ppp0".equals(networkInterface.getName())) {
                        return true;
                    }
                }
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 获取无线局域网 WLAN 名称
     *
     * @param context
     * @return
     */
    public static String getWLanMacName(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            String wifiName = cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).getExtraInfo();
            if (null == wifiName) {
                return "";
            }
            if (wifiName.startsWith("\"")) {
                wifiName = wifiName.substring(1);
            }
            if (wifiName.endsWith("\"")) {
                wifiName = wifiName.substring(0, wifiName.length() - 1);
            }
            return wifiName;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }

    /**
     * 获取无线局域网 WLAN MAC Address
     */
    public static String getWLanMacAddress(Context context) {
        WifiManager wm = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        return wm != null ? wm.getConnectionInfo().getMacAddress() : "";
    }

    /**
     * 获取MAC地址
     */
    public static String getMacAddress(Context context) {
        WifiManager wm = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        return wm != null ? wm.getConnectionInfo().getMacAddress() : "";
    }

    /**
     * 获取在WiFi环境下，获取当前连接路由器的Mac地址
     */
    public static String getWifiMacAddress(Context context) {
        WifiManager wm = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        return wm != null ? wm.getConnectionInfo().getBSSID() : "";
    }


    /**
     * 获取IP地址
     */
    public static String getIPAddress(Context context) {
        String ip = "";
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm == null) {
            return "";
        }
        NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
        NetworkInfo wifiNetworkInfo = cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        if (mobileNetworkInfo != null && mobileNetworkInfo.isConnected()) {//移动网络
            ip = getLocalIpAddress();
        } else if (wifiNetworkInfo != null && wifiNetworkInfo.isConnected()) {//wifi网络
            WifiManager wm = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            if (wm == null) {
                return "";
            }
            WifiInfo wifiInfo = wm.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            ip = getWifiIPAddress(ipAddress);
        }
        return ip;
    }

    //如果连接的是移动网络
    private static String getLocalIpAddress() {
        return "";
    }

    // 如果连接的是WI-FI网络
    private static String getWifiIPAddress(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append((ipInt >> 8) & 0xFF).append(".");
        sb.append((ipInt >> 16) & 0xFF).append(".");
        sb.append((ipInt >> 24) & 0xFF);
        return sb.toString();
    }

    /**
     * 获取蓝牙ID
     */
//    public static String getBluetoothID() {
//        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
//        if (bluetoothAdapter != null) {
//            if (bluetoothAdapter.isEnabled()) {
//                return bluetoothAdapter.getAddress();
//            }
//        }
//        return "";
//
//    }

    // Get a MemoryInfo object for the device's current memory status.
    private static ActivityManager.MemoryInfo getAvailableMemory(Context context) {
        ActivityManager am = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        if (am != null) {
            am.getMemoryInfo(memoryInfo);
        }
        return memoryInfo;
    }

    public static boolean isLowMemory(Context context) {
        ActivityManager.MemoryInfo mi = getAvailableMemory(context);
        return mi != null && mi.lowMemory;
    }

    /**
     * 获得SD卡总大小
     */
    public static String getSDTotalSize(Context context) {
        String size = "";
        if (!checkSDCardAvailable()) {
            return size;
        }
        try {
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            size = Formatter.formatFileSize(context, blockSize * totalBlocks);
        } catch (Exception e) {

        }
        return size;
    }

    public static long getSDAvailableSizeLong(Context context) {
        if (!checkSDCardAvailable()) {
            return 0L;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return blockSize * availableBlocks;
    }

    /**
     * 获得sd卡剩余容量，即可用大小
     */
    public static String getSDAvailableSize(Context context) {
        long size = getSDAvailableSizeLong(context);
        if (0 == size) {
            return "";
        }
        return Formatter.formatFileSize(context, size);
    }

    /**
     * 获取CPU型号
     */
    public static String getCpuName() {
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; i++) {
            }
            return array[1];
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 电池电量
     */
    //API 21 之后用 BATTERY_SERVICE 主动去获取电量
    public static String getBattery(Context context) {
        context = context.getApplicationContext();
        int level = 0;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            BatteryManager bm = (BatteryManager) context.getSystemService(Context.BATTERY_SERVICE);
            if (bm != null) {
                level = bm.getIntProperty(BatteryManager.BATTERY_PROPERTY_CAPACITY);
            }
        } else {
            try {
                Intent intent = context.registerReceiver(null, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
                if (null != intent) {
                    level = intent.getIntExtra("level", 0);
                }
            } catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return String.format(Locale.getDefault(), "%d%%", level);
    }

    /**
     * 获取网络状态
     */
    public static String getNetState(Context context) {
        //结果返回值
        String netType = "无网络";
        //获取手机所有连接管理对象
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm == null) {
            return "";
        }
        //获取NetworkInfo对象
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        //NetworkInfo对象为空 则代表没有网络
        if (networkInfo == null) {
            return netType;
        }
        //否则 NetworkInfo对象不为空 则获取该networkInfo的类型
        int nType = networkInfo.getType();
        if (nType == ConnectivityManager.TYPE_WIFI) {
            //WIFI
            netType = "wifi";
        } else if (nType == ConnectivityManager.TYPE_MOBILE) {
            int nSubType = networkInfo.getSubtype();
            TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            //4G
            if (nSubType == TelephonyManager.NETWORK_TYPE_LTE
                    && tm != null && !tm.isNetworkRoaming()) {
                netType = "4G";
            } else if (nSubType == TelephonyManager.NETWORK_TYPE_UMTS
                    || nSubType == TelephonyManager.NETWORK_TYPE_HSDPA
                    || nSubType == TelephonyManager.NETWORK_TYPE_EVDO_0
                    && tm != null && !tm.isNetworkRoaming()) {
                netType = "3G";
                //2G 移动和联通的2G为GPRS或EGDE，电信的2G为CDMA
            } else if (nSubType == TelephonyManager.NETWORK_TYPE_GPRS
                    || nSubType == TelephonyManager.NETWORK_TYPE_EDGE
                    || nSubType == TelephonyManager.NETWORK_TYPE_CDMA
                    && tm != null && !tm.isNetworkRoaming()) {
                netType = "2G";
            } else {
                netType = "2G";
            }
        }
        return netType;
    }

    public static String getProvidersName(Context context) {
        String providersName = "";
        try {
            TelephonyManager tm = (TelephonyManager) context.getSystemService(TELEPHONY_SERVICE);
            String subscriberId = null == tm ? null : tm.getSubscriberId();

            if (subscriberId != null) {
                if (subscriberId.startsWith("46000") || subscriberId.startsWith("46002") || subscriberId.startsWith("46007")) {
                    providersName = "中国移动";
                } else if (subscriberId.startsWith("46001")) {
                    providersName = "中国联通";
                } else if (subscriberId.startsWith("46003")) {
                    providersName = "中国电信";
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return providersName;
    }

    //获取手机唯一标识符
//    public static String getUniqueCode(Context context) {
//
//        //获取手机IMEI
//        TelephonyManager tm = (TelephonyManager) context.getSystemService(TELEPHONY_SERVICE);
//        String imei = "";
//        if (tm != null) {
//            imei = tm.getDeviceId();
//        }
//
//        //获取WLAN MAC Address
//        WifiManager wm = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
//        if (wm == null){
//            return "";
//        }
//        String macAddress = wm.getConnectionInfo().getMacAddress();
//
//
//        //获取蓝牙ID
//        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
//        String bluetoothAddress = bluetoothAdapter.getAddress();
//
//        String m_szLongID = imei + macAddress + bluetoothAddress;
//        MessageDigest m = null;
//        try {
//            m = MessageDigest.getInstance("MD5");
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//        }
//        m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
//        byte p_md5Data[] = m.digest();
//
//        StringBuilder m_szUniqueID = new StringBuilder();
//        for (int i = 0; i < p_md5Data.length; i++) {
//            int b = (0xFF & p_md5Data[i]);
//            if (b <= 0xF) {
//                m_szUniqueID.append("0");
//            }
//            m_szUniqueID = new StringBuilder(m_szUniqueID.toString().toUpperCase());
//        }
//        return m_szUniqueID.toString();
//    }

    public static String getMetrics(Context context) {
        String metric = null;
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        if (wm == null) {
            return "";
        }
        Display display = wm.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        int width = point.x;
        int height = point.y;
        metric = width + "*" + height;
        return metric;
    }

//    public static String getUniqueId(Context context) {
//        //获取手机IMEI
//        TelephonyManager tm = (TelephonyManager) context.getSystemService(TELEPHONY_SERVICE);
//        String imei = tm.getDeviceId();
//
////        //获取WLAN MAC Address
////        WifiManager wm = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
////        String WLANMAC = wm.getConnectionInfo().getMacAddress();
////
////
////        //获取蓝牙ID
////        BluetoothAdapter mBlueth = BluetoothAdapter.getDefaultAdapter();
////        String BluethId = mBlueth.getAddress();
//
////        String m_szLongID = IMEI;
//        String androidID = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
//        String id = androidID + Build.SERIAL + imei;
//        try {
//            return toMD5(id);
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//            return id;
//        }
//    }

    public static String toMD5(String text) throws NoSuchAlgorithmException {
        //获取摘要器 MessageDigest
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        //通过摘要器对字符串的二进制字节数组进行hash计算
        byte[] digest = messageDigest.digest(text.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte aDigest : digest) {
            //循环每个字符 将计算结果转化为正整数;
            int digestInt = aDigest & 0xff;
            //将10进制转化为较短的16进制
            String hexString = Integer.toHexString(digestInt);
            //转化结果如果是个位数会省略0,因此判断并补0
            if (hexString.length() < 2) {
                sb.append(0);
            }
            //将循环结果添加到缓冲区
            sb.append(hexString);
        }
        //返回整个结果
        return sb.toString();
    }

    public static boolean checkSDCardAvailable() {
        return Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState());
    }
}
