package com.dingyue.statistics.utils

import java.io.*

object FileUtil {

    private val TAG = FileUtil::class.java.name
    private val BUFFER_SIZE = 8192

    private fun fileIsExist(filePath: String?): Boolean {
        if (filePath.isNullOrBlank()) {
            return false
        }
        val f = File(filePath)
        return f.exists()
    }

    private fun readFile(filePath: String): InputStream? {
        var `is`: InputStream? = null
        if (fileIsExist(filePath)) {
            val f = File(filePath)
            try {
                `is` = FileInputStream(f)
            } catch (exception: FileNotFoundException) {
                exception.printStackTrace()
            }
        }
        return `is`
    }

    fun readBytes(filePath: String): ByteArray? {
        var data: ByteArray? = null
        val inputstream = readFile(filePath) ?: return null
        var bis:BufferedInputStream? = BufferedInputStream(inputstream)
        var outStream: ByteArrayOutputStream? = ByteArrayOutputStream()
        val buffer = ByteArray(BUFFER_SIZE)
        try {
            var len = bis?.read(buffer) ?: -1
            while ( len!= -1) {
                outStream?.write(buffer, 0, len)
                len = bis?.read(buffer) ?: -1
            }
            data = outStream?.toByteArray()
        } catch (exception: IOException) {
            exception.printStackTrace()
            return data
        } finally {
            if (bis != null) {
                try {
                    bis.close()
                    bis = null
                } catch (exception: IOException) {
                    exception.printStackTrace()
                }
            }
            if (outStream != null) {
                try {
                    outStream.close()
                    outStream = null
                } catch (exception: IOException) {
                    exception.printStackTrace()
                }
            }
        }
        // 把outStream里的数据写入内存
        return data
    }


    fun writeByteFile(filePath: String, bytes: ByteArray): Boolean {
        var success = true
        val distFile = File(filePath)
        if (!distFile.parentFile.exists()) {
            try {
                distFile.parentFile.mkdirs()
            } catch (exception: Exception) {
                exception.printStackTrace()
            }
        }
        var bos: BufferedOutputStream? = null
        try {
            bos = BufferedOutputStream(FileOutputStream(filePath), BUFFER_SIZE)
            bos.write(bytes)
        } catch (exception: Exception) {
            success = false
            exception.printStackTrace()
        } finally {
            if (bos != null) {
                try {
                    bos.close()
                    bos = null
                } catch (exception: IOException) {
                    exception.printStackTrace()
                }
            }
        }
        return success
    }

    /**
     * 追加文本日志
     *
     * @param filePath
     * @param log
     */
    fun appendLog(filePath: String, log: String) {
        var fos: FileOutputStream? = null
        try {
            val file = File(filePath)
            if (!file.parentFile.exists()) {
                file.parentFile.mkdirs()
            }
            if (!file.exists()) {
                file.createNewFile()
            }
            fos = FileOutputStream(file, true)
            fos.write((log + "\n").toByteArray())
            fos.flush()
            fos.close()
        } catch (exception: IOException) {
            exception.printStackTrace()
        } finally {
            if (fos != null) {
                try {
                    fos.close()
                } catch (exception: IOException) {
                    exception.printStackTrace()
                }
            }
        }
    }


}
