package com.dingyue.statistics.utils;

import android.app.ActivityManager;
import android.content.Context;

import java.util.List;

/**
 * @author 170303 - yangxiaowei
 * @date 2019/7/29 16:58
 * @email hn_yangxiaowei@163.com
 * @desc
 */
public class ProcessUtil {

    public static boolean isMainProcess(Context context) {
        context = context.getApplicationContext();
        ActivityManager am = ((ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE));
        List<ActivityManager.RunningAppProcessInfo> processInfos = am.getRunningAppProcesses();
        String mainProcessName = context.getPackageName();
        int myPid = android.os.Process.myPid();
        for (ActivityManager.RunningAppProcessInfo info : processInfos) {
            if (info.pid == myPid && mainProcessName.equals(info.processName)) {
                return true;
            }
        }
        return false;
    }
}
