package com.dingyue.statistics.utils;

import android.content.Context;
import android.util.DisplayMetrics;

/**
 * @author Ling Ji Nian
 * @date 2018/7/17 11:01
 * @email hn_yangxiaowei@163.com
 * @desc
 */
final public class ScreenInfo {

    public int screenWidth;
    public int screenHeight;
    public float screenDensity;
    public float screenScaledDensity;
    public int statusBarHeight;

    private static ScreenInfo instance;
    private ScreenInfo() {}



    public static ScreenInfo newInstance(Context context) {
        if (null == instance) {
            synchronized (ScreenInfo.class) {
                if (null == instance) {
                    instance = new ScreenInfo();
                    instance.init(context);
                }
            }
        }
        return instance;
    }

    private void init(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();

        this.screenWidth = dm.widthPixels;
        this.screenHeight = dm.heightPixels;

        this.screenDensity = dm.density;
        this.screenScaledDensity = dm.scaledDensity;

        this.statusBarHeight = this.getStatusBarHeight(context);
    }

    private int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}