package com.dingyue.statistics.utils

import android.util.Log
import com.dingyue.statistics.core.StatRealService


/**
 * Log打印工具类
 */
object SdkLog {

    /**
     * 是否显示日志
     */
    var log = StatRealService.config.debugMode
        get() = StatRealService.config.debugMode
        private set(value) {
            field = value
        }

    private const val TAG = "log-sdk[stat]"

    /**
     * 一般信息
     * tag
     * msg
     */
    fun i(tag: String, msg: String) {
        if (log) {
            Log.i(tag, msg)
        }
    }

    /**
     * 错误信息
     * msg
     */
    fun e(msg: String) {
        if (log) {
            Log.e(TAG, msg)
        }
    }

    /**
     * 错误信息
     * tag
     * msg
     */
    fun e(tag: String, msg: String) {
        if (log) {
            Log.e(tag, msg)
        }
    }

    /**
     * 错误信息
     * tag
     * msg
     * tr
     */
    fun e(tag: String, msg: String, tr: Throwable) {
        if (log) {
            Log.e(tag, msg, tr)
        }
    }

    /**
     * 警告信息.
     * msg
     */
    fun w(msg: String) {
        if (log) {
            Log.w(TAG, msg)
        }
    }

    /**
     * 警告信息.
     * tag
     * msg
     */
    fun w(tag: String, msg: String) {
        if (log) {
            Log.w(tag, msg)
        }
    }

    /**
     * 警告信息.
     * tag
     * msg
     */
    fun w(tag: String, msg: String, tr: Throwable) {
        if (log) {
            Log.w(tag, msg, tr)
        }
    }

    /**
     * debug信息.
     * msg
     */
    fun d(msg: String) {
        if (log) {
            Log.d(TAG, msg)
        }
    }

    /**
     * debug信息.
     * tag
     * msg
     */
    fun d(tag: String, msg: String) {
        if (log) {
            Log.d(tag, msg)
        }
    }

    /**
     * 详细信息
     * tag
     * msg
     */
    fun v(tag: String, msg: String) {
        if (log) {
            Log.v(tag, msg)
        }
    }
}
