package com.dingyue.statistics.uuid

import android.Manifest
import android.content.Context
import android.os.Build
import android.os.Environment
import android.provider.Settings
import android.support.v4.content.PermissionChecker
import android.telephony.TelephonyManager
import com.dingyue.statistics.application.ApplicationWrapper
import com.dingyue.statistics.telephony.IPhoneSubInfo
import com.dingyue.statistics.utils.*
import java.io.File
import java.lang.Class.forName
import java.lang.reflect.InvocationTargetException
import java.net.NetworkInterface
import java.net.SocketException
import java.security.MessageDigest
import java.util.*


/**
 * Created by yuchao on 2018/11/6 0006.
 * Mail yuchao_liu@dingyuegroup.cn
 * Desc 生成设备物理id
 */
object DeviceUniqueIdProvider {

//    // 应用SD卡缓存路径
//    private val APP_PATH by lazy { GlobalConstants.getAppPath() }
//
//    // 在SD卡缓存路径基础上添加包名MD5命名的文件夹
//    private val CACHE_DIR by lazy { getMD5(CommonParams.appPackageName ?: "device", false) }

    // 设备唯一物理ID 外部存储 存放路径
    private val CACHE_PATH by lazy { Environment.getExternalStorageDirectory().absolutePath.plus(File.separator).plus(".idf") }
//    // 备份到隐藏目录
//    private val CACHE_PATH_HIDE by lazy {
//        val dir = APP_PATH.split("/").last()
//        val path = APP_PATH.removeRange(APP_PATH.length - dir.length, APP_PATH.length)
//        path.plus(".$dir").plus(File.separator).plus("idf").plus(File.separator).plus(CACHE_DIR)
//    }

    // 隐藏存放文件名,防止用户误删
    private val DEVICES_FILE_NAME = ".IDF"

    private val USELESS_ANDROID_ID = "9774d56d682e549c"

    private val SP_DEVICES_ID = "devices_id_location"

    private val KEY_DEVICES_ID = "devices_id"

    private val share by lazy { SharedPreferencesUtil(ApplicationWrapper.getInstance().context.getSharedPreferences(SP_DEVICES_ID, Context.MODE_PRIVATE)) }

    var diviceID = ""
        get() {
            if (field == "") {
                field = getDeviceId()
            }
            return field
        }

    var androidID = ""
        get() {
            if (field == "") {
                field= getAndroidId(ApplicationWrapper.getInstance().context)
            }
            return field
        }

    fun getDeviceId(): String {

        SdkLog.e("DeviceUniqueIdProvider: 使用本地缓存 getDeviceId")

        // 获取外部存储物理id
        var readDeviceID = readCacheDeviceID()
        // 获取内部存储物理id
        val str = share.getString(KEY_DEVICES_ID, readDeviceID)

        // 判断内部是否已经缓存,若已经缓存则使用内部缓存
        if (!str.isNullOrBlank()) {
            // 外部存储被清空的情况(用户误删除), 复原外部存储
            if (readDeviceID.isNullOrBlank() || readDeviceID != str) {
                readDeviceID = str!!
                saveDeviceID(readDeviceID)
            }
        }

        // 内部没有缓存 (这种情况只会发生在第一次启动的时候)
        if (readDeviceID.isNullOrBlank()) {
            SdkLog.e("DeviceUniqueIdProvider: 使用本地缓存 readCacheDeviceID null")
            // 生成设备id
            readDeviceID = findDeviceId()
        }
        // 应用御卸 或 内存被清理 再次更新app 的缓存
        share.putString(SP_DEVICES_ID, readDeviceID)

        return readDeviceID
    }

    fun getImei(): String {

        var imei: String? = null
        val context = ApplicationWrapper.getInstance().context
        var telephonyManager: TelephonyManager? = null
        try {
            if (PermissionChecker.PERMISSION_GRANTED == PermissionChecker.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)) {
                telephonyManager = context
                        .getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager
                imei = telephonyManager.deviceId
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

        if (imei.isNullOrBlank()) {
            // SPD
            try {
                if (PermissionChecker.PERMISSION_GRANTED == PermissionChecker.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)) {
                    val cons = TelephonyManager::class.java
                            .getDeclaredConstructor(Context::class.java, Int::class.java)
                    val instance = cons.newInstance(context, 1)
                    imei = instance.deviceId
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }

            // MTK1
            if (imei == null) {
                try {
                    val cons = TelephonyManager::class.java
                            .getDeclaredConstructor(Context::class.java)
                    val instance = cons.newInstance(context)
                    val iPhoneSubInfo = invokeJarMethod(
                            "getSubscriberInfo", arrayOf(Int::class.java),
                            arrayOf(1), TelephonyManager::class.java,
                            instance) as IPhoneSubInfo
                    imei = iPhoneSubInfo.deviceId
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }

            //MTK2
            if (imei == null) {
                try {
                    val qClass = forName("com.mediatek.telephony.TelephonyManagerEx")
                    val localConstructor = qClass.getConstructor(Context::class.java)
                    val instance = localConstructor.newInstance(context)
                    val md = qClass.getMethod("getDeviceId", Int::class.javaPrimitiveType)
                    val imei1 = md.invoke(instance, 0) as? String
                    val imei2 = md.invoke(instance, 1) as? String
                    if (imei1 != null) {
                        imei = imei1
                    } else if (imei2 != null) {
                        imei = imei2
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }

            //QCOM
            if (imei == null) {
                try {
                    val qClass = forName("android.telephony.MSimTelephonyManager")
                    val localConstructor = qClass.getConstructor()
                    val instance = localConstructor.newInstance()
                    val obj = context.getSystemService("phone_msim")
                    imei = invokeJarMethod(
                            "getDeviceId", arrayOf(Any::class.java, Int::class.java),
                            arrayOf(obj, 1), qClass,
                            instance) as String
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }

        if (!imei.isNullOrBlank()) {
            //如果获取的是 MEID, 再次获取 IMEI
            if (imei!!.length == 14) {
                var isNextStep = false
                try {
                    val con = forName(telephonyManager?.javaClass?.name)
                    val ms1 = con.getMethod("getPhoneCount")
                    ms1.isAccessible = true
                    val count = ms1.invoke(telephonyManager) as Int

                    val ms = con.getMethod("getImei", Int::class.javaPrimitiveType)
                    ms.isAccessible = true
                    for (i in 0 until count) {
                        val imeiAg = ms.invoke(telephonyManager, i) as? String
                        if (imeiAg != null && imeiAg != "" && imeiAg.length == 15) {
                            imei = imeiAg
                            isNextStep = true
                            break
                        }
                    }
                } catch (e: ClassNotFoundException) {
                    e.printStackTrace()
                } catch (e: NoSuchMethodException) {
                    e.printStackTrace()
                } catch (e: SecurityException) {
                    e.printStackTrace()
                } catch (e: IllegalAccessException) {
                    e.printStackTrace()
                } catch (e: IllegalArgumentException) {
                    e.printStackTrace()
                } catch (e: InvocationTargetException) {
                    e.printStackTrace()
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                if (!isNextStep) {
                    try {
                        val con = forName(telephonyManager?.javaClass?.name)
                        val ms1 = con.getMethod("getPhoneCount")
                        ms1.isAccessible = true
                        val count = ms1.invoke(telephonyManager) as Int
                        for (i in 0 until count) {
                            val ms = TelephonyManager::class.java.getMethod("getDeviceId", Int::class.javaPrimitiveType)
                            ms.isAccessible = true
                            val imeiAg = ms.invoke(telephonyManager, i) as String?
                            if (imeiAg != null && imeiAg != "" && imeiAg.length == 15) {
                                imei = imeiAg
                                break
                            }
                        }
                    } catch (e: ClassNotFoundException) {
                        e.printStackTrace()
                    } catch (e: NoSuchMethodException) {
                        e.printStackTrace()
                    } catch (e: SecurityException) {
                        e.printStackTrace()
                    } catch (e: IllegalAccessException) {
                        e.printStackTrace()
                    } catch (e: IllegalArgumentException) {
                        e.printStackTrace()
                    } catch (e: InvocationTargetException) {
                        e.printStackTrace()
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                }
            }
        }

        if (imei == null) {
            imei = ""
        }

        return imei
    }

    @Throws(NoSuchMethodException::class, IllegalAccessException::class, InvocationTargetException::class)
    private fun invokeJarMethod(methodName: String,
                                classArray: Array<Class<*>>, objectArray: Array<Any>, serviceClass: Class<*>?,
                                serviceInstance: Any?): Any? {
        return if (serviceClass != null || serviceInstance != null) {
            val method = serviceClass!!.getDeclaredMethod(methodName,
                    *classArray)
            method.isAccessible = true
            var return_obj = Any()
            if (serviceInstance == null) {
                return_obj = method.invoke(serviceClass, *objectArray) as Any
            } else {
                return_obj = method.invoke(serviceInstance,
                        *objectArray) as Any
            }
            return_obj
        } else {
            null
        }
    }

    /**
     * 生成设备物理id
     */
    fun findDeviceId(): String {

        //读取保存的在sd卡中的唯一标识符
        var deviceId = readCacheDeviceID()
        //判断是否已经生成过
        if ("" != deviceId) {
            SdkLog.e("DeviceUniqueIdProvider: 使用本地缓存 deviceId -- $deviceId}")
            return deviceId
        }

        //用于生成最终的唯一标识符
        val s = StringBuffer()

        deviceId = getImei()
        SdkLog.e("DeviceUniqueIdProvider: 获取IMEI deviceId -- $deviceId}")
        s.append(deviceId)

        try {
            //获取设备的MACAddress地址 去掉中间相隔的冒号
            deviceId = getLocalMacAddress().replace(":", "")
            SdkLog.e("DeviceUniqueIdProvider: 获取MacAddress deviceId -- $deviceId}")
            s.append(deviceId)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        if (s.isEmpty()) {
            // 获取失败时再使用AndroidId, 避免回复出厂值或刷机带来的影响
            deviceId = getAndroidId()
            SdkLog.e("DeviceUniqueIdProvider: 获取AndroidId deviceId -- $deviceId}")
            s.append(deviceId)
        }

        //如果以上没有获取相应的id则自己生成相应的UUID作为相应设备唯一标识
        if (s.isEmpty()) {
            val uuid = UUID.randomUUID()
            deviceId = uuid.toString().replace("-", "")
            SdkLog.e("DeviceUniqueIdProvider: 获取randomUUID deviceId -- $deviceId}")
            s.append(deviceId)
        }

        // md5加密 统一长度 最终生成32位(小写)字符串
        val md5 = getMD5(s.toString(), false)
        if (s.isNotEmpty()) {
            // 持久化操作, 保存到SD卡中
            SdkLog.e("DeviceUniqueIdProvider: 获取md5 md5 -- $md5}")
            saveDeviceID(md5)
        }
        return md5
    }

    /**
     * 保存id到SD卡
     */
    fun saveDeviceID(str: String) {
        var file = getDevicesDir()
        SdkLog.e("DeviceUniqueIdProvider: file.absolutePath -- ${file.absolutePath}")
        FileUtil.writeByteFile(file.absolutePath, SimpleEncrypt.encrypt(str.toByteArray()))
//        file = getDevicesDir(true)
//        SdkLog.e("DeviceUniqueIdProvider: file.absolutePath hide-- ${file.absolutePath}")
//        FileUtil.writeByteFile(file.absolutePath, SimpleEncrypt.encrypt(str.toByteArray()))
    }

    /**
     * 使用MD5加密转十六进制, 生成标志32位长度字符串
     * @param upperCase 是否使用大写
     */
    fun getMD5(message: String, upperCase: Boolean): String {

        var md5str = ""
        try {
            val md = MessageDigest.getInstance("MD5")

            val input = message.toByteArray(Charsets.UTF_8)

            val buff = md.digest(input)

            md5str = bytesToHex(buff, upperCase)

        } catch (e: Exception) {
            e.printStackTrace()
        }
        return md5str
    }

    /**
     * 字节数组转十六进制
     * @param upperCase 是否使用大写
     */
    fun bytesToHex(bytes: ByteArray, upperCase: Boolean): String {
        val md5str = StringBuffer()
        var digital: Int
        for (b in bytes) {
            digital = b.toInt()

            if (digital < 0) {
                digital += 256
            }
            if (digital < 16) {
                md5str.append("0")
            }
            md5str.append(Integer.toHexString(digital))
        }
        if (upperCase) {
            return md5str.toString().toUpperCase()
        }
        return md5str.toString().toLowerCase()
    }

    /**
     * 获取android_id
     */
    fun getAndroidId(): String {
        var id = Settings.System.getString(ApplicationWrapper.getInstance().context.contentResolver, Settings.Secure.ANDROID_ID)
        if (id == null || USELESS_ANDROID_ID == id) id = ""
        return id
    }

    /**
     * 获取Mac地址
     */
    fun getLocalMacAddress(): String {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            getMachineHardwareAddress()
        } else {
            AppUtil.getMacAddress(ApplicationWrapper.getInstance().context)
        }
    }

    /**
     * Mac地址, 6.0及以上设备获取方法
     */
    fun getMachineHardwareAddress(): String {
        val macAddress: String?
        val buf = StringBuffer()
        var networkInterface: NetworkInterface?
        try {
            networkInterface = NetworkInterface.getByName("eth1")
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByName("wlan0")
            }
            if (networkInterface == null) {
                return ""
            }
            val adds = networkInterface.hardwareAddress

            for (b in adds) {
                buf.append(String.format("%02X:", b))
            }
            if (buf.isNotEmpty()) {
                buf.deleteCharAt(buf.length - 1)
            }
            macAddress = buf.toString()
        } catch (e: SocketException) {
            e.printStackTrace()
            return ""
        }
        return macAddress
    }

    /**
     * 读取唯一物理id 外部缓存
     */
    fun readCacheDeviceID(): String {
        var file = getDevicesDir()
        SdkLog.e("DeviceUniqueIdProvider: file.absolutePath -- ${file.absolutePath}")
        var bytes = FileUtil.readBytes(file.absolutePath)
        var id = if (bytes != null) {
            String(SimpleEncrypt.encrypt(bytes))
        } else ""
//        if (id.isNullOrBlank()) {
//            file = getDevicesDir(true)
//            SdkLog.e("DeviceUniqueIdProvider: file.absolutePath hide-- ${file.absolutePath}")
//            bytes = FileUtil.readBytes(file.absolutePath)
//            id = if (bytes != null) { String(SimpleEncrypt.encrypt(bytes)) } else ""
//            saveDeviceID(id)
//        }
        return id
    }

    /**
     * 设备唯一物理id 外部存储 存放位置
     */
    fun getDevicesDir(): File {
        val cacheDir = File(CACHE_PATH)
        if (!cacheDir.exists()) {
            cacheDir.mkdirs()
        }
        return File(cacheDir, DEVICES_FILE_NAME)
    }


    private fun getAndroidId(context: Context): String {
        val androidId = Settings.System.getString(context.contentResolver, Settings.Secure.ANDROID_ID)
        return "$androidId$androidId"
    }
}