package net.iyouqu.video.app.data;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;

import net.iyouqu.video.app.request.EsRetryPolicy;
import net.iyouqu.video.app.request.EsStringRequest;
import net.iyouqu.video.app.request.RequestManager;
import net.iyouqu.video.basecommon.utils.LogUtils;

import org.json.JSONException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DataServiceNew {

	static String TAG = "DataServiceNew";

	/**
	 * 公共部分
	 *
	 * @param url
	 * @param handler
	 * @param resultCode
	 * @param errorCode
	 * @param parser
	 */

	protected static void publicCode(String url, Map<String, String> params,
			final Handler handler, final int resultCode, final int errorCode,
			final Parser parser, boolean isEzip) {

		publicCode(url, params, handler, resultCode, errorCode, parser, 
				EsRetryPolicy.DEFAULT_TIMEOUT_MS, EsRetryPolicy.DEFAULT_MAX_RETRIES, isEzip);
	}
	
	protected static void publicCode(String url, Map<String, String> params,
			final Handler handler, final int resultCode, final int errorCode,
			final Parser parser) {

		publicCode(url, params, handler, resultCode, errorCode, parser, 
				EsRetryPolicy.DEFAULT_TIMEOUT_MS, EsRetryPolicy.DEFAULT_MAX_RETRIES, true);
	}
	protected static void publicCode(String url, Map<String, String> params,
			final Handler handler, final int resultCode, final int errorCode,
			final Parser parser, int timeOut){
		publicCode(url, params, handler, resultCode, errorCode, parser, timeOut, 
				EsRetryPolicy.DEFAULT_MAX_RETRIES, true);
	}
	protected static void publicCode(String url, Map<String, String> params,
			final Handler handler, final int resultCode, final int errorCode,
			final Parser parser, int timeOut, int retry, boolean isEZip) {

		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				try {
					Message msg = handler.obtainMessage();
					msg.what = resultCode;
					msg.obj = parser.parserMethod(response);
					handler.sendMessage(msg);

				} catch (JSONException e) {
					e.printStackTrace();
					Message msg = handler.obtainMessage();
					msg.what = errorCode;
					msg.obj = e;
					handler.sendMessage(msg);
				} catch (Exception e) {
					e.printStackTrace();
					Message msg = handler.obtainMessage();
					msg.what = errorCode;
					msg.obj = e;
					handler.sendMessage(msg);
				}
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				Message msg = handler.obtainMessage();
				msg.what = errorCode;
				msg.obj = error;
				handler.sendMessage(msg);
			}
		};

		Request<String> jsonRequest = new EsStringRequest(url, params,
				listener, errorListener, timeOut, retry, isEZip);
		if (params == null && url != null) {
			jsonRequest.setTag(url);
			queue.cancelAll(url);
		}
		queue.add(jsonRequest);
	}


	public interface DataServiceTagCallBack {
		void onSuccess(Object result, Object tag);

		void onError(Exception error, Object tag);
	}

	public interface DataServiceCallBack {
		/**
		 * 里面如果处理ui需要放到主线程中处理
		 *
		 * @param result
		 */
		void onSuccess(Object result);

		void onError(Exception error);
	}

	/**
	 * @param url
	 * @param callBack
	 * @param parser
	 */

	protected static void publicCode(String url, Map<String, String> params,
			final DataServiceCallBack callBack, final Parser parser) {
		
		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				try {
					if (callBack != null) {
						callBack.onSuccess(parser.parserMethod(response));
					}

				} catch (JSONException e) {
					e.printStackTrace();
					if (callBack != null) {
						callBack.onError(e);
					}
				} catch (Exception e) {
					e.printStackTrace();
					if (callBack != null) {
						callBack.onError(e);
					}
				}
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				if (callBack != null) {
					callBack.onError(error);
				}
			}
		};

		Request<String> jsonRequest = new EsStringRequest(url, params,
				listener, errorListener);
		if (params == null && url != null) {
			jsonRequest.setTag(url);
			queue.cancelAll(url);
		}
		queue.add(jsonRequest);
	}

	/**
	 * @param url
	 * @param callBack
	 * @param parser
	 * @param tag
	 */

	protected static void publicCode(String url, Map<String, String> params,
			final DataServiceTagCallBack callBack, final Parser parser,
			final Object tag) {

		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				try {
					if (callBack != null) {
						callBack.onSuccess(parser.parserMethod(response), tag);
						LogUtils.d("tag " + tag.toString());
					}

				} catch (JSONException e) {
					e.printStackTrace();
					if (callBack != null) {
						callBack.onError(e, tag);
					}
				} catch (Exception e) {
					e.printStackTrace();
					if (callBack != null) {
						callBack.onError(e, tag);
					}
				}
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				if (callBack != null) {
					callBack.onError(error, tag);
				}
			}
		};

		Request<String> jsonRequest = new EsStringRequest(url, params,
				listener, errorListener);
		if (params == null && url != null) {
			jsonRequest.setTag(url);
			queue.cancelAll(url);
		}
		queue.add(jsonRequest);
	}

	public static void makeRequest(final VolleyInterface v){
		makeRequest(v, true);
	}
	public static void makeRequest(final VolleyInterface v, boolean refresh){
		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				v.parserResponse(response, 0);
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				v.parserVolleyError(error, 0);
			}
		};

		EsStringRequest request = v.getRequest(refresh, listener, errorListener, 0);
		if (request == null) {
			return;
		}
		try {
			if (request.getParams() == null && request.getUrl() != null) {
				request.setTag(request.getUrl());
				queue.cancelAll(request.getUrl());
			}
		} catch (AuthFailureError e) {
			e.printStackTrace();
		}
		queue.add(request);
	}
	
}
