package net.iyouqu.video.app.data;

import net.iyouqu.video.app.request.EsStringRequest;

import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.VolleyError;

public interface VolleyInterface {

	/**
	 * 合成Request对象
	 * 
	 * @param page
	 * @param reflash
	 * @param listener
	 * @param errorListener
	 * @return
	 */
	EsStringRequest getRequest(boolean reflash, Listener<String> listener,
			ErrorListener errorListener, int tag);

	/**
	 * 解析并返回想要的数据格式
	 * 
	 * @param response
	 * @return
	 */
	Object parserResponse(String response, int tag);

	/**
	 * 处理网络错误
	 * 
	 * @param error
	 */
	void parserVolleyError(VolleyError error, int tag);
}
