package net.iyouqu.video.app.data;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;
/**
 * @ClassName: VolleySingleton 
 * @Description: TODO(volley 工具类) 
 * @author Bruce 
 * @date 2015-6-23 下午6:51:10 
 */
public class VolleySingleton {
	private static VolleySingleton volleySingleton;
	private RequestQueue requestQueue; 
	private ImageLoader imageLoader;
	private static Context mContext;
	
	private VolleySingleton(Context context) {
		mContext = context;
		requestQueue = getRequestQueue();
		imageLoader = new ImageLoader(requestQueue, new LruBitmapCache(LruBitmapCache.getCacheSize(mContext)));
	}

	private RequestQueue getRequestQueue() {
		if(requestQueue == null){
			requestQueue = Volley.newRequestQueue(mContext.getApplicationContext());
		}
		return requestQueue;
	}
	
	public static synchronized VolleySingleton getInstance(Context context){
		if(volleySingleton == null){
			volleySingleton = new VolleySingleton(context);
		}
		return volleySingleton;
	}
	
	public <T> void addToRequestQueue(Request<T> request){
		getRequestQueue().add(request);
	}
	
	public ImageLoader getImageLoader(){
		return imageLoader;
	}
}
