package net.iyouqu.video.app.imagecache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import net.iyouqu.video.basecommon.utils.FileUtils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.BitmapFactory;
import android.util.Log;

import com.android.volley.Cache.Entry;
import com.android.volley.toolbox.ImageLoader.ImageCache;

public class DiskCache implements ImageCache {

	private static int IO_BUFFER_SIZE = 8 * 1024;
	private static final int MIN_STORE = 10 * 1024 *1024;
	
	private static CompressFormat DISK_IMAGECACHE_COMPRESS_FORMAT = CompressFormat.JPEG;
	private static int DISK_IMAGECACHE_QUALITY = 100;
	
	private VolleyDiskCache volleyDiskCache;
	
	public DiskCache(Context context, String path) {
		File cacheDir = null;
    	try {
    		String sdPath = FileUtils.getSDCardPath();
    		if (FileUtils.isSDcardExist() && sdPath!=null
        			&& FileUtils.getExternalSpace()>MIN_STORE) {
        		cacheDir = new File(sdPath, path);
        		Log.e("Volley", "cacheDir:"+cacheDir.getAbsolutePath());
    		}else {
    			cacheDir = new File(context.getCacheDir(), path);
    			Log.e("Volley", "cacheDir:"+cacheDir.getAbsolutePath());
    		}
		} catch (Exception e) {
			e.printStackTrace();
			cacheDir = new File(context.getCacheDir(), path);
			Log.e("Volley", "cacheDir:"+cacheDir.getAbsolutePath());
		}
    	if (cacheDir != null && !cacheDir.exists()) {
			cacheDir.mkdirs();
		}
		volleyDiskCache = new VolleyDiskCache(cacheDir);
		new Thread(new Runnable() {
			
			@Override
			public void run() {
				volleyDiskCache.initialize();
			}
		}).start();
	}

	@Override
	public Bitmap getBitmap(String url) {
//		String filePath = cachePath + FileCache.decodeKey(url) + cacheType.extension;
//		Bitmap bitmap = null;
//		try {
//			byte[] data = FileUtils.readBytes(filePath);
//			if (data != null && data.length > 0) {
//				BitmapFactory.Options options = new BitmapFactory.Options();
//				options.inSampleSize = 2;
//				options.inJustDecodeBounds = true;
//				bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		}catch (OutOfMemoryError e) {
//			e.printStackTrace();
//			System.gc();
//			System.gc();
//		}
//		return bitmap;
		if (volleyDiskCache != null) {
			Bitmap bitmap = null;
			
			Entry entry = volleyDiskCache.get(url);
			if (entry != null) {
				bitmap = FileUtils.doParse(entry.data);
			}
			
			return bitmap;
		}
		
		return null;
	}

	@Override
	public void putBitmap(String url, Bitmap bitmap) {
//		String filePath = cachePath + FileCache.decodeKey(url) + cacheType.extension;
//		OutputStream out = null;
//		try {
//			out = new BufferedOutputStream(new FileOutputStream(filePath), IO_BUFFER_SIZE);
//			bitmap.compress(DISK_IMAGECACHE_COMPRESS_FORMAT, DISK_IMAGECACHE_QUALITY, out);
//		} catch (FileNotFoundException e) {
//			e.printStackTrace();
//		}catch (Exception e) {
//			e.printStackTrace();
//		}finally {
//			if (out != null) {
//				try {
//					out.close();
//				} catch (IOException e) {
//				}
//			}
//		}
	}

}
