package net.iyouqu.video.app.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import net.iyouqu.video.app.input.EsencInputStreamHelper;
import net.iyouqu.video.app.input.InputStreamUtils;

import org.json.JSONException;
import org.json.JSONObject;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonObjectRequest;

public class CustomJsonObjectRequest extends JsonObjectRequest {

	private Priority priority = Priority.NORMAL;
	private Map<String, String> headers = new HashMap<String, String>();
	private Map<String, String> params;
	@Override
	public com.android.volley.Request.Priority getPriority() {
		return priority;
	}

	@Override
	public Map<String, String> getHeaders() throws AuthFailureError {
		return headers;
	}

	// TODO 
	@Override
	public RetryPolicy getRetryPolicy() {
		return super.getRetryPolicy();
	}

	// TODO
	@Override
	public String getCacheKey() {
		return super.getCacheKey();
	}

	public CustomJsonObjectRequest(int method, String url, JSONObject jsonRequest, Listener<JSONObject> listener,
			ErrorListener errorListener, boolean shouldCache, Priority priority,
			EsencInputStreamHelper.EsEncoding esEncoding) {
		super(method, url, jsonRequest, listener, errorListener);
		setShouldCache(shouldCache);
		this.priority = Priority.NORMAL;
		this.headers.put("Accept-Encoding", esEncoding.encoding);
	}

	public CustomJsonObjectRequest(String url, Listener<JSONObject> listener, ErrorListener errorListener) {
		this(Method.GET, url, null, listener, errorListener, true, Priority.NORMAL,
				EsencInputStreamHelper.EsEncoding.ESENCGZIP);
	}
	
	public CustomJsonObjectRequest(String url,Map<String, String> params, Listener<JSONObject> listener, ErrorListener errorListener) {
		this(Method.POST, url, null, listener, errorListener, true, Priority.NORMAL,
				EsencInputStreamHelper.EsEncoding.ESENCGZIP);
		this.params = params;
	}
	
	@Override
	protected Map<String, String> getParams() throws AuthFailureError {
		return params;
	}
	
	@Override
	protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
		InputStream input = null;
		try {
			input = new ByteArrayInputStream(response.data);
			input = EsencInputStreamHelper.getInputStream(response.headers, input);
			String jsonString = InputStreamUtils.getString(input, HttpHeaderParser.parseCharset(response.headers));
			return Response.success(new JSONObject(jsonString), HttpHeaderParser.parseCacheHeaders(response));
		} catch (UnsupportedEncodingException e) {
			return Response.error(new ParseError(e));
		} catch (JSONException je) {
			return Response.error(new ParseError(je));
		} catch (IOException ie) {
			return Response.error(new ParseError(ie));
		} finally {
			try {
				if (input != null) {
					input.close();
				}
			} catch (Exception e) {
			}
		}
	}

}
